/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.optics.lensLanguage;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import one.xingyi.core.client.IResourceList;
import one.xingyi.core.client.ISimpleList;
import one.xingyi.core.marshelling.JsonParserAndWriter;
import one.xingyi.core.optics.Lens;
import one.xingyi.core.optics.lensLanguage.LensDefnStore;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.utils.Sets;

public class LensStore<J> {
    private final Map<String, Lens<Object, Object>> map;
    private JsonParserAndWriter<J> json;

    public LensStore(JsonParserAndWriter<J> json, LensDefnStore store) {
        this.json = json;
        this.map = Lists.aggLeft(new HashMap(), store.defns, (map, line) -> map.put(line.lensName, Lists.foldLeft(Lens.identity(), line.defns, (lens, defn) -> lens.andThen(defn.asLens(json)))));
    }

    Supplier<RuntimeException> illegallens(String lensName) {
        return () -> {
            throw new RuntimeException("cannot find lens: " + lensName + "\nLegal values are" + Sets.sortedString(this.map.keySet(), ","));
        };
    }

    public Lens<J, String> stringLens(String lensName) {
        return Optional.ofNullable(this.map.get(lensName)).orElseThrow(this.illegallens(lensName));
    }

    public Lens<J, Integer> integerLens(String lensName) {
        return Optional.ofNullable(this.map.get(lensName)).orElseThrow(this.illegallens(lensName));
    }

    public Lens<J, Double> doubleLens(String lensName) {
        return Optional.ofNullable(this.map.get(lensName)).orElseThrow(this.illegallens(lensName));
    }

    public Lens<J, Boolean> booleanLens(String lensName) {
        return Optional.ofNullable(this.map.get(lensName)).orElseThrow(this.illegallens(lensName));
    }

    public Lens<J, IResourceList<J>> listLens(String lensName) {
        return Optional.ofNullable(this.map.get(lensName)).orElseThrow(this.illegallens(lensName));
    }

    public <T> Lens<J, ISimpleList<T>> simpleListLens(String lensName) {
        return Optional.ofNullable(this.map.get(lensName)).orElseThrow(this.illegallens(lensName));
    }
}

