/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.optics.lensLanguage;

import java.util.List;
import one.xingyi.core.client.ISimpleList;
import one.xingyi.core.marshelling.JsonParserAndWriter;
import one.xingyi.core.optics.Lens;
import one.xingyi.core.optics.lensLanguage.LensDefn;

public class SimpleListLensDefn<T>
implements LensDefn<ISimpleList<T>> {
    static List<String> primitives = List.of("string", "integer", "double", "boolean");
    public final String name;
    public final String primitiveClassName;

    public SimpleListLensDefn(String name, String primitiveClassName) {
        this.name = name;
        this.primitiveClassName = primitiveClassName;
        if (!primitives.contains(primitiveClassName.toLowerCase())) {
            throw new IllegalArgumentException("Cannot make a " + this.getClass().getSimpleName() + " for " + primitiveClassName + " legal values are " + primitives);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String asString() {
        return this.name + "/**" + this.primitiveClassName;
    }

    @Override
    public <J> Lens<J, ISimpleList<T>> asLens(JsonParserAndWriter<J> json) {
        return json.lensToSimpleList(this.name, this.primitiveClassName);
    }

    public String toString() {
        return "SimpleListLensDefn(name=" + this.name + ", primitiveClassName=" + this.primitiveClassName + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleListLensDefn)) {
            return false;
        }
        SimpleListLensDefn other = (SimpleListLensDefn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$primitiveClassName = this.primitiveClassName;
        String other$primitiveClassName = other.primitiveClassName;
        return !(this$primitiveClassName == null ? other$primitiveClassName != null : !this$primitiveClassName.equals(other$primitiveClassName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleListLensDefn;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $primitiveClassName = this.primitiveClassName;
        result = result * 59 + ($primitiveClassName == null ? 43 : $primitiveClassName.hashCode());
        return result;
    }
}

