/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.reflection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.utils.WrappedException;

public class ReflectionOn<T> {
    final T t;

    public <Result> List<Method> findMethodsWithReturnType(Class<Result> returnClazz, Function<Method, Boolean> acceptor) {
        return WrappedException.wrapCallable(() -> {
            ArrayList<Method> result = new ArrayList<Method>();
            for (Method m : this.t.getClass().getMethods()) {
                if (!returnClazz.isAssignableFrom(m.getReturnType()) || !((Boolean)acceptor.apply(m)).booleanValue()) continue;
                result.add(m);
            }
            return result;
        });
    }

    public <Result> List<Result> invokeNoParamMethodsWithReturnType(Class<Result> returnClazz, Function<Method, Boolean> acceptor) {
        return Lists.map(this.findMethodsWithReturnType(returnClazz, acceptor), m -> m.invoke(this.t, new Object[0]));
    }

    public <Result> List<Result> methodsParamsAndWithReturnType(Class<Result> returnClazz, Function<Method, Boolean> acceptor, Object ... params) {
        List<Method> filter = Lists.filter(this.findMethodsWithReturnType(returnClazz, acceptor), method -> {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == params.length) {
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (parameterTypes[i].isAssignableFrom(params[i].getClass())) continue;
                    return false;
                }
                return true;
            }
            return false;
        });
        return Lists.map(filter, method -> method.invoke(this.t, params));
    }

    public ReflectionOn(T t) {
        this.t = t;
    }
}

