/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.sdk;

import java.util.List;
import one.xingyi.core.endpoints.EndPoint;
import one.xingyi.core.reflection.ReflectionOn;
import one.xingyi.core.sdk.IXingYiServerCompanion;
import one.xingyi.core.server.EndpointHandler;
import one.xingyi.core.server.HttpUtils;
import one.xingyi.core.server.SimpleServer;
import one.xingyi.core.utils.Lists;

public interface IXingYiServer {
    public List<IXingYiServerCompanion<?, ?>> companions();

    default public List<EndPoint> allEndpoints() {
        return new ReflectionOn<IXingYiServer>(this).invokeNoParamMethodsWithReturnType(EndPoint.class, m -> !m.getName().equalsIgnoreCase("endpoint"));
    }

    default public EndPoint endpoint() {
        return EndPoint.compose(this.allEndpoints());
    }

    default public SimpleServer simpleServer(int port) {
        return new SimpleServer(HttpUtils.makeDefaultExecutor(), new EndpointHandler(this.endpoint()), port);
    }

    default public SimpleServer simpleServerWithLog(int port) {
        return new SimpleServer(HttpUtils.makeDefaultExecutor(), new EndpointHandler(EndPoint.printlnLog(this.endpoint())), port);
    }

    default public List<String> allLensLens() {
        return Lists.flatMap(this.companions(), IXingYiServerCompanion::lensLines);
    }
}

