/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.server;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import one.xingyi.core.endpoints.EndPoint;
import one.xingyi.core.server.EndpointHandler;
import one.xingyi.core.server.HttpUtils;
import one.xingyi.core.utils.ConsumerWithException;
import one.xingyi.core.utils.WrappedException;

public class SimpleServer {
    final HttpServer server = WrappedException.wrapCallable(() -> HttpServer.create());
    final Executor executor;
    final int port;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doAndThenStop(int port, EndPoint endPoints, ConsumerWithException<SimpleServer> consumer) {
        ExecutorService executor = HttpUtils.makeDefaultExecutor();
        SimpleServer server = new SimpleServer(executor, new EndpointHandler(endPoints), port);
        try {
            server.start();
            WrappedException.wrapConsumer(consumer).accept(server);
        }
        finally {
            server.stop();
            executor.shutdown();
        }
    }

    public SimpleServer(Executor executor, HttpHandler handler, int port) {
        this.executor = executor;
        this.port = port;
        this.server.createContext("/", handler);
        this.server.setExecutor(executor);
    }

    public void start() {
        WrappedException.wrap(() -> this.server.bind(new InetSocketAddress(this.port), 0));
        this.server.start();
    }

    public void stop() {
        this.server.stop(1);
    }

    public void stopAndKillExecutors() {
        this.server.stop(1);
    }

    public String toString() {
        return "SimpleServer(server=" + this.server + ", executor=" + this.executor + ", port=" + this.port + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleServer)) {
            return false;
        }
        SimpleServer other = (SimpleServer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpServer this$server = this.server;
        HttpServer other$server = other.server;
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        Executor this$executor = this.executor;
        Executor other$executor = other.executor;
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        return this.port == other.port;
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleServer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpServer $server = this.server;
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        Executor $executor = this.executor;
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        result = result * 59 + this.port;
        return result;
    }
}

