/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.state;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import one.xingyi.core.client.IResourceList;
import one.xingyi.core.marshelling.JsonWriter;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.utils.Optionals;

public class StateData {
    public final String action;
    public final String link;

    public static <J> J toJson(JsonWriter<J> writer, String state, Map<String, List<StateData>> stateMap) {
        return (J)Optionals.fold(Optional.ofNullable(stateMap.get(state)), () -> writer.makeList(IResourceList.create(new Object[0])), listOfStates -> writer.makeList(Lists.map(listOfStates, s -> writer.makeObject(s.action, s.link))));
    }

    public StateData(String action, String link) {
        this.action = action;
        this.link = link;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StateData)) {
            return false;
        }
        StateData other = (StateData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$action = this.action;
        String other$action = other.action;
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$link = this.link;
        String other$link = other.link;
        return !(this$link == null ? other$link != null : !this$link.equals(other$link));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StateData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $action = this.action;
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $link = this.link;
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        return result;
    }

    public String toString() {
        return "StateData(action=" + this.action + ", link=" + this.link + ")";
    }
}

