/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.store;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.utils.IdAndValue;
import one.xingyi.core.utils.RunnableWithException;
import one.xingyi.core.utils.WrappedException;

public abstract class ControllerUsingMap<T> {
    public final Map<String, T> store;
    final String entityName;

    protected abstract T prototype(String var1);

    public ControllerUsingMap(String entityName) {
        this.entityName = entityName;
        this.store = Collections.synchronizedMap(new HashMap());
    }

    public CompletableFuture<T> wrap(String id, RunnableWithException runnable) {
        WrappedException.wrap(runnable);
        return CompletableFuture.completedFuture(Optional.ofNullable(this.store.get(id)).orElseThrow(() -> new RuntimeException("Cannot find " + this.entityName + " with id: " + id)));
    }

    public CompletableFuture<T> put(IdAndValue<T> idAndEntity) {
        return this.wrap(idAndEntity.id, () -> this.store.put(idAndEntity.id, idAndEntity.t));
    }

    public CompletableFuture<T> get(String id) {
        return CompletableFuture.completedFuture(this.store.get(id));
    }

    public CompletableFuture<Optional<T>> getOptional(String id) {
        return CompletableFuture.completedFuture(Optional.ofNullable(this.store.get(id)));
    }

    public CompletableFuture<Boolean> delete(String id) {
        this.store.remove(id);
        return CompletableFuture.completedFuture(true);
    }

    public CompletableFuture<T> createWithId(String id) {
        return this.wrap(id, () -> {
            T prototype = this.prototype(id);
            this.store.put(id, prototype);
        });
    }

    public CompletableFuture<IdAndValue<T>> createWithoutId(T t) {
        String id = "" + this.store.size();
        this.store.put(id, t);
        return CompletableFuture.completedFuture(new IdAndValue<T>(id, t));
    }

    public T createWithoutIdRequestFrom(ServiceRequest serviceRequest) {
        return this.prototype(Integer.toString(this.store.size()));
    }
}

