/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.typeDom;

import one.xingyi.core.annotationProcessors.IViewDefnNameToViewName;
import one.xingyi.core.client.IResourceList;
import one.xingyi.core.client.ISimpleList;
import one.xingyi.core.codeDom.FieldDom;
import one.xingyi.core.codeDom.PackageAndClassName;
import one.xingyi.core.embedded.Embedded;
import one.xingyi.core.names.EntityNames;
import one.xingyi.core.names.IServerNames;
import one.xingyi.core.names.ViewNames;
import one.xingyi.core.typeDom.BooleanPrimitiveType;
import one.xingyi.core.typeDom.DoublePrimitiveType;
import one.xingyi.core.typeDom.EmbeddedType;
import one.xingyi.core.typeDom.IntegerPrimitiveType;
import one.xingyi.core.typeDom.ListType;
import one.xingyi.core.typeDom.PrimitiveType;
import one.xingyi.core.typeDom.SimpleListType;
import one.xingyi.core.typeDom.StringPrimitiveType;
import one.xingyi.core.typeDom.ViewType;
import one.xingyi.core.utils.PartialFunction;
import one.xingyi.core.utils.Strings;
import one.xingyi.core.validation.Result;

public interface TypeDom {
    public static final PartialFunction<String, Result<String, TypeDom>> fromString = PartialFunction.pf(fullTypeName -> fullTypeName.equals(String.class.getName()), fullTypeName -> Result.succeed(new StringPrimitiveType()));
    public static final PartialFunction<String, Result<String, TypeDom>> fromInteger = PartialFunction.pf(fullTypeName -> fullTypeName.equals(Integer.class.getName()) || fullTypeName.equals(Integer.TYPE.getName()), fullTypeName -> Result.succeed(new IntegerPrimitiveType()));
    public static final PartialFunction<String, Result<String, TypeDom>> fromDouble = PartialFunction.pf(fullTypeName -> fullTypeName.equals(Double.class.getName()) || fullTypeName.equals(Double.TYPE.getName()), fullTypeName -> Result.succeed(new DoublePrimitiveType()));
    public static final PartialFunction<String, Result<String, TypeDom>> fromBoolean = PartialFunction.pf(fullTypeName -> fullTypeName.equals(Boolean.class.getName()) || fullTypeName.equals(Boolean.TYPE.getName()), fullTypeName -> Result.succeed(new BooleanPrimitiveType()));

    public String fullTypeName();

    default public String forEntity() {
        return this.fullTypeName();
    }

    default public String forView() {
        return this.fullTypeName();
    }

    default public String viewCompanion() {
        return "";
    }

    public TypeDom nested();

    public boolean primitive();

    public String entityNameForLens();

    public String makeLens(PackageAndClassName var1, String var2, FieldDom var3, String var4);

    default public String forToJson(String fieldName, boolean templated) {
        return fieldName;
    }

    public String forFromJson(String var1);

    public String lensDefn(String var1);

    public static PartialFunction<String, Result<String, TypeDom>> fromSimpleList(IServerNames names, IViewDefnNameToViewName viewNamesMap) {
        return PartialFunction.pf(fullTypeName -> fullTypeName.startsWith(ISimpleList.class.getName()), fullTypeName -> {
            String nested = Strings.extractFromOptionalEnvelope(ISimpleList.class.getName() + "<", ">", fullTypeName);
            return TypeDom.create(names, nested, viewNamesMap).flatMap(td -> {
                if (td instanceof PrimitiveType) {
                    return Result.succeed(new SimpleListType((String)fullTypeName, (PrimitiveType)td));
                }
                return Result.failwith("Can only have a ISimpleList of a primitive type. Was " + td.getClass().getSimpleName());
            });
        });
    }

    public static PartialFunction<String, Result<String, TypeDom>> fromEmbedded(IServerNames names, IViewDefnNameToViewName viewNamesMap) {
        return PartialFunction.pf(fullTypeName -> fullTypeName.startsWith(Embedded.class.getName()), fullTypeName -> TypeDom.create(names, Strings.extractFromOptionalEnvelope(Embedded.class.getName() + "<", ">", fullTypeName), viewNamesMap).map(nested -> new EmbeddedType((String)fullTypeName, (TypeDom)nested)));
    }

    public static PartialFunction<String, Result<String, TypeDom>> fromResourceList(IServerNames names, IViewDefnNameToViewName viewNamesMap) {
        return PartialFunction.pf(fullTypeName -> fullTypeName.startsWith(IResourceList.class.getName()), fullTypeName -> {
            String nestedName = Strings.extractFromOptionalEnvelope(IResourceList.class.getName() + "<", ">", fullTypeName);
            return TypeDom.create(names, nestedName, viewNamesMap).flatMap(nested -> {
                if (viewNamesMap.isDefinedAt(nestedName)) {
                    ViewNames vn = (ViewNames)viewNamesMap.apply(nestedName);
                    EntityNames entityNames = vn.entityNames;
                    return Result.succeed(new ListType((String)fullTypeName, (TypeDom)nested, entityNames.serverCompanion, entityNames.entityNameForLens));
                }
                return Result.failwith("Could not work out which type " + fullTypeName + "was. Known views are\n" + viewNamesMap.legalValues());
            });
        });
    }

    public static PartialFunction<String, Result<String, TypeDom>> fromView(IViewDefnNameToViewName viewNamesMap) {
        return PartialFunction.pf(fullTypeName -> viewNamesMap.isDefinedAt(fullTypeName) && fullTypeName.indexOf("<") == -1, fullTypeName -> {
            ViewNames vn = (ViewNames)viewNamesMap.apply(fullTypeName);
            EntityNames tr = vn.entityNames;
            String serviceInterface = tr.serverInterface.asString();
            return Result.succeed(new ViewType((String)fullTypeName, serviceInterface, vn.clientView.asString(), vn.clientCompanion.asString(), tr.serverCompanion.asString(), tr.entityNameForLens));
        });
    }

    public static Result<String, TypeDom> create(IServerNames names, String rawTypeName, IViewDefnNameToViewName viewNamesMap) {
        String fullTypeName = Strings.removeOptionalFirst("()", rawTypeName);
        PartialFunction<String, Result> pf = PartialFunction.chain(fromString, fromInteger, fromBoolean, fromDouble, TypeDom.fromEmbedded(names, viewNamesMap), TypeDom.fromResourceList(names, viewNamesMap), TypeDom.fromView(viewNamesMap), TypeDom.fromSimpleList(names, viewNamesMap));
        return pf.orDefault(fullTypeName, () -> Result.failwith("Could not work out what type " + fullTypeName + " was. Known views are\n" + viewNamesMap.legalValues()));
    }

    public boolean isAssignableFrom(TypeDom var1);
}

