/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.utils;

import java.util.List;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import one.xingyi.core.annotationProcessors.ElementFail;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.utils.Optionals;
import one.xingyi.core.validation.Result;

public interface LoggerAdapter {
    public void info(String var1);

    public void info(Element var1, String var2);

    public void warning(Element var1, String var2);

    public void error(Element var1, String var2);

    default public void error(ElementFail fail) {
        Optionals.doit(fail.optElement, () -> this.error(fail.message), e -> this.error((Element)e, fail.message));
    }

    default public <T> List<T> logFailuresAndReturnSuccesses(List<Result<ElementFail, T>> list) {
        Lists.foreach(Result.failures(list), this::error);
        return Result.successes(list);
    }

    default public <T> List<T> logFailuresAndReturnStringSuccesses(List<Result<String, T>> list) {
        Lists.foreach(Result.failures(list), this::error);
        return Result.successes(list);
    }

    public void error(String var1);

    public LoggerAdapter withElement(Element var1);

    public static LoggerAdapter fromMessager(final Messager messager, final Element element) {
        return new LoggerAdapter(){

            @Override
            public void info(String message) {
                messager.printMessage(Diagnostic.Kind.NOTE, message, element);
            }

            @Override
            public void info(Element element2, String message) {
                messager.printMessage(Diagnostic.Kind.NOTE, message, element2);
            }

            @Override
            public void warning(Element element2, String message) {
                messager.printMessage(Diagnostic.Kind.WARNING, message, element2);
            }

            @Override
            public void error(Element element2, String message) {
                messager.printMessage(Diagnostic.Kind.ERROR, message, element2);
            }

            @Override
            public void error(String message) {
                messager.printMessage(Diagnostic.Kind.ERROR, message, element);
            }

            @Override
            public LoggerAdapter withElement(Element element2) {
                return LoggerAdapter.fromMessager(messager, element2);
            }
        };
    }

    public static LoggerAdapter fromMessager(final Messager messager) {
        return new LoggerAdapter(){

            @Override
            public void info(String message) {
                messager.printMessage(Diagnostic.Kind.NOTE, message);
            }

            @Override
            public void info(Element element, String message) {
                messager.printMessage(Diagnostic.Kind.NOTE, message, element);
            }

            @Override
            public void warning(Element element, String message) {
                messager.printMessage(Diagnostic.Kind.WARNING, message, element);
            }

            @Override
            public void error(Element element, String message) {
                messager.printMessage(Diagnostic.Kind.ERROR, message, element);
            }

            @Override
            public void error(String message) {
                messager.printMessage(Diagnostic.Kind.ERROR, message);
            }

            @Override
            public LoggerAdapter withElement(Element element) {
                return LoggerAdapter.fromMessager(messager, element);
            }
        };
    }
}

