/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.utils;

import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import one.xingyi.core.utils.ChainPartialFunction;
import one.xingyi.core.utils.SimplePartialFunction;

public interface PartialFunction<From, To>
extends Function<From, To> {
    public boolean isDefinedAt(From var1);

    default public To orDefault(From from, Supplier<To> defSupplier) {
        if (this.isDefinedAt(from)) {
            return (To)this.apply(from);
        }
        return defSupplier.get();
    }

    public static <From, To> PartialFunction<From, To> pf(Function<From, Boolean> acceptor, Function<From, To> fn) {
        return new SimplePartialFunction<From, To>(acceptor, fn);
    }

    @SafeVarargs
    public static <From, To> PartialFunction<From, To> chain(PartialFunction<From, To> ... pfs) {
        return new ChainPartialFunction<From, To>(Arrays.asList(pfs));
    }
}

