/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.validation;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import one.xingyi.core.utils.Lists;

public interface Valid<Fail, T>
extends Function<T, List<Fail>> {
    public static <Fail, T> Valid<Fail, T> check(Function<T, Boolean> isOk, Function<T, Fail> message) {
        return t -> (Boolean)isOk.apply(t) != false ? List.of() : List.of(message.apply(t));
    }

    public static <Fail, Fail1, T> Valid<Fail1, T> check(Function<T, Boolean> isOk, Function<T, Fail> message, BiFunction<T, Fail, Fail1> failFn) {
        return t -> (Boolean)isOk.apply(t) != false ? List.of() : List.of(failFn.apply(t, message.apply(t)));
    }

    public static <Fail, T> Valid<Fail, T> compose(Valid<Fail, T> ... valids) {
        return t -> Lists.flatMap(Arrays.asList(valids), v -> (List)v.apply(t));
    }

    public static <Fail, T> List<Fail> checkAll(List<T> ts, Valid<Fail, T> valid) {
        return Lists.flatMap(ts, s -> (List)valid.apply(s));
    }
}

