/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.endpoints;

import java.util.List;
import java.util.function.Function;
import one.xingyi.core.endpoints.EndpointConfig;
import one.xingyi.core.endpoints.EndpointContext;
import one.xingyi.core.endpoints.EndpointResult;
import one.xingyi.core.endpoints.IMergeJavascriptAndJson;
import one.xingyi.core.http.Header;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.javascript.JavascriptDetailsToString;
import one.xingyi.core.marshelling.JsonParserAndWriter;
import one.xingyi.core.sdk.TestResource;
import one.xingyi.core.utils.FunctionFixture;
import one.xingyi.core.utils.IdAndValue;
import one.xingyi.json.Json;
import org.junit.Assert;
import org.junit.Test;

public class EndpointResultTest
implements FunctionFixture {
    ServiceRequest serviceRequestNoHost = new ServiceRequest("someMethod", "/somePath", List.of(), "");
    ServiceRequest serviceRequestHost = new ServiceRequest("someMethod", "/somePath", List.of(new Header("host", "someHost")), "");
    EndpointContext<Object> context = new EndpointConfig("rootJavascript", (JsonParserAndWriter)new Json(), "http://", JavascriptDetailsToString.simple, IMergeJavascriptAndJson.simple).from(List.of());
    Function<TestResource, String> stateFn = e -> "someState";

    @Test
    public void testCreate() {
        ServiceResponse serviceResponse = EndpointResult.create(this.context, (String)"/some/{id}", (int)314).apply(this.serviceRequestHost, (Object)new TestResource());
        Assert.assertEquals((long)314L, (long)serviceResponse.statusCode);
        Assert.assertEquals((Object)"rootJavascript\n---------\n{\"test\":\"parserAndWriter\"}", (Object)serviceResponse.body);
    }

    @Test
    public void testCreateForIdAndValue() {
        ServiceResponse serviceResponse = EndpointResult.createForIdAndvalue(this.context, (String)"/some/{id}", (int)314, e -> "").apply(this.serviceRequestHost, (Object)new IdAndValue("someId", (Object)new TestResource()));
        Assert.assertEquals((long)314L, (long)serviceResponse.statusCode);
        Assert.assertEquals((Object)"rootJavascript\n---------\n{\"id\":\"someId\",\"value\":{\"test\":\"parserAndWriter\"}}", (Object)serviceResponse.body);
    }

    @Test
    public void testCreateForNonEntity() {
        TestResource entity = new TestResource();
        ServiceResponse serviceResponse = EndpointResult.createForNonEntity((int)314, (Function)this.fn(entity, "someJson")).apply(this.serviceRequestHost, (Object)entity);
        Assert.assertEquals((long)314L, (long)serviceResponse.statusCode);
        Assert.assertEquals((Object)"someJson", (Object)serviceResponse.body);
    }
}

