/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.httpClient;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import junit.framework.TestCase;
import one.xingyi.core.httpClient.HttpServiceCompletableFuture;
import one.xingyi.core.httpClient.client.view.UrlPattern;
import one.xingyi.core.httpClient.client.viewcompanion.UrlPatternCompanion;
import one.xingyi.core.sdk.IXingYiRemoteAccessDetails;
import org.junit.Test;
import org.mockito.Mockito;

public class UrlPatternTest {
    Function<UrlPattern, String> getFn = UrlPattern::urlPattern;
    String url = "http://localhost:9000/bookmarkAndUrl";

    @Test
    public void testDelegatesGetPrimitiveToHttpService() throws ExecutionException, InterruptedException {
        HttpServiceCompletableFuture service = (HttpServiceCompletableFuture)Mockito.mock(HttpServiceCompletableFuture.class);
        Mockito.when((Object)service.primitive((IXingYiRemoteAccessDetails)UrlPatternCompanion.companion, "get", this.url, this.getFn)).thenReturn(CompletableFuture.completedFuture("someUrlPattern"));
        String actual = (String)UrlPatternCompanion.companion.primitive(service, "get", this.url, this.getFn).get();
        TestCase.assertEquals((String)"someUrlPattern", (String)actual);
    }

    @Test
    public void testDelegatesCallToHttpService() throws ExecutionException, InterruptedException {
        HttpServiceCompletableFuture service = (HttpServiceCompletableFuture)Mockito.mock(HttpServiceCompletableFuture.class);
        Mockito.when((Object)service.get((IXingYiRemoteAccessDetails)UrlPatternCompanion.companion, "someId", this.getFn)).thenReturn(CompletableFuture.completedFuture("someUrlPattern"));
        String actual = (String)UrlPattern.get((HttpServiceCompletableFuture)service, (String)"someId", this.getFn).get();
        TestCase.assertEquals((String)"someUrlPattern", (String)actual);
    }
}

