/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.mediatype;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import junit.framework.TestCase;
import one.xingyi.core.endpoints.EndpointConfig;
import one.xingyi.core.endpoints.EndpointContext;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.marshelling.ContextForJson;
import one.xingyi.core.marshelling.DataToBeSentToClient;
import one.xingyi.core.marshelling.JsonParserAndWriter;
import one.xingyi.core.mediatype.IResourceEndpoints;
import one.xingyi.core.mediatype.IXingYiServerMediaTypeDefn;
import one.xingyi.core.sdk.IXingYiResource;
import one.xingyi.core.utils.FunctionFixture;
import one.xingyi.json.Json;
import one.xingyi.reference3.person.server.companion.PersonCompanion;
import one.xingyi.reference3.person.server.domain.Person;
import one.xingyi.test.IReferenceFixture3;
import org.junit.Test;

public abstract class AbstractEntityServerMediaTypeEndpointTest<M extends IXingYiServerMediaTypeDefn<Person>>
implements FunctionFixture,
IReferenceFixture3 {
    private EndpointContext<Object> context = EndpointConfig.defaultConfig((JsonParserAndWriter)new Json()).from(List.of(PersonCompanion.companion));
    protected IResourceEndpoints<Person> endpoints = this.serverMediaType().endpoints("http", PersonCompanion.companion.bookmarkAndUrl(), p -> "");

    protected abstract M serverMediaType();

    protected ServiceRequest sr(String url) {
        return ServiceRequest.sr((String)"get", (String)url, (String)"application/xingyi.json.javascript.person");
    }

    @Test
    public void testGetReturnsNoneifDoesntMatch() throws ExecutionException, InterruptedException {
        Optional opt = (Optional)((CompletableFuture)this.endpoints.get(this.kleisli("never called", person)).apply((Object)this.sr("/doesnt/match"))).get();
        TestCase.assertEquals(Optional.empty(), (Object)opt);
    }

    @Test
    public void testGetReturnsDataAndDefnifMatchs() throws ExecutionException, InterruptedException {
        ServiceRequest serviceRequest = this.sr("/person/someId");
        DataToBeSentToClient expected = this.serverMediaType().makeDataAndDefn(ContextForJson.forServiceRequest((String)"http", (ServiceRequest)serviceRequest), p -> "", (IXingYiResource)person);
        ServiceResponse resp = (ServiceResponse)((Optional)((CompletableFuture)this.endpoints.get(this.kleisli("someId", person)).apply((Object)serviceRequest)).get()).get();
        TestCase.assertEquals((int)200, (int)resp.statusCode);
        TestCase.assertEquals((String)expected.asString(), (String)resp.body);
    }

    @Test
    public void testTheJsonContainsLinks() {
        DataToBeSentToClient dataToBeSent = this.serverMediaType().makeDataAndDefn(ContextForJson.forServiceRequest((String)"http", (ServiceRequest)this.sr("/person/someId")), p -> "", (IXingYiResource)person);
        String data = dataToBeSent.data;
        TestCase.assertTrue((String)data, (boolean)data.contains("_links"));
        TestCase.assertTrue((String)data, (boolean)data.contains("/person/someId"));
    }
}

