/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.mediatype;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.marshelling.DataToBeSentToClient;
import one.xingyi.core.mediatype.SimpleClientMediaTypeDefn;
import one.xingyi.core.mediatype.SimpleMediaTypeDefnTest;
import one.xingyi.core.mediatype.SimpleServerMediaTypeDefn;
import one.xingyi.core.sdk.IXingYiResource;
import one.xingyi.reference3.person.client.entitydefn.IPersonClientEntity;
import one.xingyi.reference3.person.client.view.PersonNameView;
import one.xingyi.reference3.person.server.domain.Person;
import org.junit.Assert;
import org.junit.Test;

abstract class SimpleMediaTypeDefnClientTests<J, Server extends SimpleServerMediaTypeDefn<J, Person>, Client extends SimpleClientMediaTypeDefn<IPersonClientEntity, PersonNameView>>
extends SimpleMediaTypeDefnTest<Server> {
    SimpleMediaTypeDefnClientTests() {
    }

    abstract Client clientMediaDefn();

    @Override
    protected String acceptHeader() {
        return this.clientMediaDefn().acceptHeader(Set.of());
    }

    @Test(expected=RuntimeException.class)
    public void testAcceptHeaderWithUnhappyPath() {
        Set<String> capabilities = Set.of("one", "two", "three");
        String acceptHeader = "wrong" + this.acceptHeader();
        Assert.assertFalse((String)acceptHeader, (boolean)((SimpleServerMediaTypeDefn)this.serverMediaDefn()).accept(acceptHeader));
        ((SimpleServerMediaTypeDefn)this.serverMediaDefn()).lensNames(acceptHeader);
    }

    @Test
    public void testAcceptHeaderWithhappyPath() {
        Set<String> capabilities = Set.of("one", "two", "three");
        String acceptHeader = this.clientMediaDefn().acceptHeader(capabilities);
        Assert.assertTrue((boolean)acceptHeader.contains("." + entityName + "."));
        Assert.assertTrue((String)acceptHeader, (boolean)((SimpleServerMediaTypeDefn)this.serverMediaDefn()).accept(acceptHeader));
        Assert.assertEquals((String)acceptHeader, capabilities, new HashSet(((SimpleServerMediaTypeDefn)this.serverMediaDefn()).lensNames(acceptHeader)));
    }

    @Test
    public void testCanTurnAPersonOnTheServerIntoAView() throws ExecutionException, InterruptedException {
        DataToBeSentToClient dataToBeSentToClient = ((SimpleServerMediaTypeDefn)this.serverMediaDefn()).makeDataAndDefn(this.contextForJson, p -> "", (IXingYiResource)person);
        PersonNameView newPerson = (PersonNameView)this.clientMediaDefn().makeFrom(new ServiceResponse(200, dataToBeSentToClient.asString(), List.of())).get();
        Assert.assertEquals((Object)person.name(), (Object)newPerson.name());
    }

    @Test
    public void testCanTurnAPersonAndIdOnTheServerIntoAView() throws ExecutionException, InterruptedException {
        DataToBeSentToClient dataToBeSentToClient = ((SimpleServerMediaTypeDefn)this.serverMediaDefn()).makeDataAndDefn(this.contextForJson, p -> "", (IXingYiResource)person);
        PersonNameView newPerson = (PersonNameView)this.clientMediaDefn().makeFrom(new ServiceResponse(200, dataToBeSentToClient.asString(), List.of())).get();
        Assert.assertEquals((Object)person.name(), (Object)newPerson.name());
    }
}

