/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.mediatype;

import java.util.List;
import one.xingyi.core.endpoints.EndpointConfig;
import one.xingyi.core.endpoints.EndpointContext;
import one.xingyi.core.http.Header;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.marshelling.ContextForJson;
import one.xingyi.core.marshelling.JsonParserAndWriter;
import one.xingyi.core.mediatype.IMediaTypeServerDefn;
import one.xingyi.json.Json;
import one.xingyi.reference3.address.server.companion.AddressCompanion;
import one.xingyi.reference3.person.server.companion.PersonCompanion;
import one.xingyi.reference3.person.server.domain.Person;
import one.xingyi.reference3.telephone.server.companion.TelephoneNumberCompanion;
import one.xingyi.test.IReferenceFixture3;
import org.junit.Assert;
import org.junit.Test;

public abstract class SimpleMediaTypeDefnTest<MediaType extends IMediaTypeServerDefn<Person>>
implements IReferenceFixture3 {
    protected static String entityName = "Person";
    protected EndpointConfig<Object> config = EndpointConfig.defaultConfig((JsonParserAndWriter)new Json());
    protected EndpointContext<Object> context = this.config.from(List.of(PersonCompanion.companion, AddressCompanion.companion, TelephoneNumberCompanion.companion));
    ServiceRequest serviceRequest = new ServiceRequest("get", "/who/cares", List.of(new Header("host", "somehost"), new Header("accept", this.acceptHeader())), "unimportant");
    ContextForJson contextForJson = ContextForJson.forServiceRequest((String)"http://", (ServiceRequest)this.serviceRequest);

    protected abstract MediaType serverMediaDefn();

    protected abstract String acceptHeader();

    protected abstract String makeJsonFromContextAndPerson();

    @Test
    public void testCanParseAndThenRetrievePersonOnServer() {
        String acceptHeader = this.acceptHeader();
        String json = this.makeJsonFromContextAndPerson();
        Person newPerson = (Person)this.serverMediaDefn().makeEntityFrom(acceptHeader, json);
        Assert.assertEquals((Object)person, (Object)newPerson);
    }
}

