/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.primitives;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import junit.framework.TestCase;
import one.xingyi.core.client.ISimpleList;
import one.xingyi.core.endpoints.EndPoint;
import one.xingyi.core.endpoints.EndpointConfig;
import one.xingyi.core.httpClient.HttpServiceCompletableFuture;
import one.xingyi.core.marshelling.JsonParserAndWriter;
import one.xingyi.core.sdk.IXingYiClientResource;
import one.xingyi.core.sdk.IXingYiRemoteAccessDetails;
import one.xingyi.core.sdk.IXingYiResource;
import one.xingyi.core.sdk.IXingYiServer;
import one.xingyi.core.sdk.IXingYiView;
import one.xingyi.core.utils.BiConsumerWithException;
import one.xingyi.core.utils.IdAndValue;
import one.xingyi.json.Json;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractSimpleListTest<Resource extends IXingYiResource, ClientResource extends IXingYiClientResource, View extends IXingYiView<ClientResource>, Server extends IXingYiServer, T> {
    protected EndpointConfig<Object> config = EndpointConfig.defaultConfig((JsonParserAndWriter)new Json());

    protected String id() {
        return "someId";
    }

    protected String newId() {
        return "someNewId";
    }

    protected abstract Server server();

    protected abstract IXingYiRemoteAccessDetails<ClientResource, View> accessDetails();

    protected abstract ISimpleList<T> getItem(View var1);

    protected abstract View withItem(View var1, ISimpleList<T> var2);

    protected abstract T item1();

    protected abstract T item2();

    protected abstract T item3();

    ISimpleList<T> list123() {
        return ISimpleList.fromList(List.of(this.item1(), this.item2(), this.item3()));
    }

    protected void setup(BiConsumerWithException<HttpServiceCompletableFuture, Server> block) throws Exception {
        Server server = this.server();
        Function serverKleisli = EndPoint.toKliesli((EndPoint)EndPoint.compose((List)server.allEndpoints(), (boolean)true));
        HttpServiceCompletableFuture service = HttpServiceCompletableFuture.lensService((String)"http://localhost:9000", (JsonParserAndWriter)this.config.parserAndWriter, (Function)serverKleisli);
        block.accept((Object)service, server);
    }

    @Test
    public void testGet() throws Exception {
        this.setup((service, server) -> {
            TestCase.assertEquals((Object)ISimpleList.fromList(List.of(this.item1())), service.get(this.accessDetails(), this.id(), this::getItem).get());
            TestCase.assertEquals(this.item1(), service.get(this.accessDetails(), this.id(), i -> this.getItem(i).get(0)).get());
            TestCase.assertEquals((int)1, (int)((Integer)service.get(this.accessDetails(), this.id(), i -> this.getItem(i).size()).get()));
        });
    }

    @Test
    public void testGetOptional() throws Exception {
        this.setup((service, server) -> {
            TestCase.assertEquals(Optional.of(ISimpleList.fromList(List.of(this.item1()))), service.getOptional(this.accessDetails(), this.id(), this::getItem).get());
            TestCase.assertEquals(Optional.empty(), service.getOptional(this.accessDetails(), this.newId(), this::getItem).get());
            TestCase.assertEquals(Optional.of(this.item1()), service.getOptional(this.accessDetails(), this.id(), i -> this.getItem(i).get(0)).get());
            TestCase.assertEquals((int)1, (int)((Integer)((Optional)service.getOptional(this.accessDetails(), this.id(), i -> this.getItem(i).size()).get()).get()));
        });
    }

    @Test
    public void testCreateWithoutId() throws Exception {
        this.setup((service, server) -> {
            IXingYiView prototype = (IXingYiView)service.get(this.accessDetails(), this.id(), Function.identity()).get();
            IXingYiView newView = this.withItem(prototype, this.list123());
            IdAndValue idAndValue = (IdAndValue)service.createWithoutId(this.accessDetails(), newView).get();
            Assert.assertFalse((boolean)idAndValue.id.equals(this.id()));
        });
    }

    @Test
    public void testPrototype() throws Exception {
        this.setup((service, server) -> {
            IXingYiView created = (IXingYiView)service.prototype(this.accessDetails(), "prototype", this.id(), v -> this.withItem(v, this.list123())).get();
            TestCase.assertEquals(this.list123(), service.get(this.accessDetails(), this.id(), this::getItem).get());
        });
    }

    @Test
    public void testDelete() throws Exception {
        this.setup((service, server) -> {
            IXingYiView view = (IXingYiView)service.create(this.accessDetails(), this.newId()).get();
            service.delete(this.accessDetails(), this.newId()).get();
            TestCase.assertEquals(Optional.empty(), service.getOptional(this.accessDetails(), this.newId(), Function.identity()).get());
        });
    }

    @Test
    public void testEditModifyingItems() throws Exception {
        this.setup((service, server) -> {
            service.edit(this.accessDetails(), this.id(), v -> this.withItem(v, this.getItem(v).withItem(0, this.item2()))).get();
            TestCase.assertEquals((Object)ISimpleList.fromList(List.of(this.item2())), this.getItem((IXingYiView)service.get(this.accessDetails(), this.id(), Function.identity()).get()));
        });
    }
}

