/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.test;

import java.util.List;
import java.util.function.Supplier;
import junit.framework.TestCase;
import one.xingyi.core.client.IResourceList;
import one.xingyi.core.client.ISimpleList;
import one.xingyi.core.marshelling.ContextForJson;
import one.xingyi.core.marshelling.JsonParserAndWriter;
import one.xingyi.core.optics.Lens;
import one.xingyi.reference3.person.server.companion.PersonCompanion;
import one.xingyi.rest2test.server.companion.PrimitivesCompanion;
import one.xingyi.rest2test.server.domain.Primitives;
import one.xingyi.test.AbstractJsonWriterTests;
import org.junit.Test;

public abstract class AbstractJsonParserWriterTests<J>
extends AbstractJsonWriterTests<J> {
    protected abstract JsonParserAndWriter<J> parserWriter();

    @Test
    public void testCanGetDataFromJson() {
        Object json = this.parserWriter().parse(this.jsonString);
        TestCase.assertEquals((String)"someName", (String)this.parserWriter().asString(this.parserWriter().child(json, "name")));
        TestCase.assertEquals((int)23, (int)this.parserWriter().asInt(this.parserWriter().child(json, "age")));
    }

    @Test
    public void testCanLoadAPersonFromJson() {
        Object json = this.parserWriter().parse(this.jsonString);
        TestCase.assertEquals((Object)person, (Object)PersonCompanion.companion.fromJson(this.parserWriter(), json));
    }

    <T> void check(Supplier<Lens<J, T>> supplier, T expected, T newValue) {
        Object json = this.parserWriter().parse(this.jsonString);
        Lens<J, T> lens = supplier.get();
        TestCase.assertEquals(expected, (Object)lens.get(json));
        Object newJ = lens.set(json, newValue);
        TestCase.assertEquals(expected, (Object)lens.get(json));
        TestCase.assertEquals(newValue, (Object)lens.get(newJ));
    }

    @Test
    public void testStringLens() {
        this.check(() -> this.parserWriter().lensToString("name"), "someName", "newName");
    }

    @Test
    public void testIntegerLens() {
        this.check(() -> this.parserWriter().lensToInteger("age"), 23, 999);
    }

    @Test
    public void testChildLens() {
        this.check(() -> this.parserWriter().lensToChild("telephone").andThen(this.parserWriter().lensToString("number")), "someNumber", "newNumber");
    }

    @Test
    public void testList() {
        Lens line1 = this.parserWriter().lensToString("line1");
        Object json = this.parserWriter().parse(this.jsonString);
        Lens lens = this.parserWriter().lensToSimpleList("addresses");
        IResourceList addresses = (IResourceList)lens.get(json);
        Object firstChildJson = addresses.get(0);
        Object secondChildJson = addresses.get(1);
        TestCase.assertEquals((String)"someLine1a", (String)((String)line1.get(firstChildJson)));
        TestCase.assertEquals((String)"someLine1b", (String)((String)line1.get(secondChildJson)));
    }

    @Test
    public void testReadingLists() {
        Object json = this.parserWriter().parse(this.jsonStringWithLists);
        TestCase.assertEquals((Object)ISimpleList.fromList(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))), (Object)this.parserWriter().asSimpleIntegerList(json, "listOfInts"));
        TestCase.assertEquals((Object)ISimpleList.fromList(List.of("one", "two", "three")), (Object)this.parserWriter().asSimpleStringList(json, "listOfStrings"));
        TestCase.assertEquals((Object)ISimpleList.fromList(List.of(Double.valueOf(1.0), Double.valueOf(2.0), Double.valueOf(3.0))), (Object)this.parserWriter().asSimpleDoubleList(json, "listOfDoubles"));
        TestCase.assertEquals((Object)ISimpleList.fromList(List.of(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false))), (Object)this.parserWriter().asSimpleBooleanList(json, "listOfBooleans"));
    }

    @Test
    public void testWritingLists() {
        Primitives primitives = new Primitives("name", Integer.valueOf(1), Integer.valueOf(2), Boolean.valueOf(false), Boolean.valueOf(true), Double.valueOf(1.0), Double.valueOf(2.2), ISimpleList.fromList(List.of("one", "two", "three")), ISimpleList.fromList(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))), ISimpleList.fromList(List.of(Double.valueOf(1.0), Double.valueOf(2.1), Double.valueOf(3.3))), ISimpleList.fromList(List.of(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false))));
        String json = this.jsonWriter().fromJ(primitives.toJson(this.jsonWriter(), ContextForJson.nullContext));
        System.out.println(json);
        Primitives roundTrip = PrimitivesCompanion.companion.fromJson(this.parserWriter(), this.parserWriter().parse(json));
        TestCase.assertEquals((Object)primitives, (Object)roundTrip);
    }
}

