/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.test;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import junit.framework.TestCase;
import one.xingyi.core.endpoints.EndPoint;
import one.xingyi.core.endpoints.EndpointConfig;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.httpClient.HttpServiceCompletableFuture;
import one.xingyi.core.httpClient.client.view.UrlPattern;
import one.xingyi.core.httpClient.client.viewcompanion.UrlPatternCompanion;
import one.xingyi.core.marshelling.JsonParser;
import one.xingyi.core.marshelling.JsonParserAndWriter;
import one.xingyi.core.marshelling.UnexpectedResponse;
import one.xingyi.core.sdk.IXingYiRemoteAccessDetails;
import one.xingyi.core.sdk.IXingYiView;
import one.xingyi.core.utils.DigestAndString;
import one.xingyi.core.utils.IdAndValue;
import one.xingyi.democlient.client.compositeView.IPersonNameLine12View;
import one.xingyi.json.Json;
import one.xingyi.reference1.person.client.view.PersonLine12View;
import one.xingyi.reference3.PersonServer;
import one.xingyi.reference3.person.PersonController;
import one.xingyi.reference3.person.client.view.PersonNameView;
import one.xingyi.reference3.person.client.viewcompanion.PersonNameViewCompanion;
import one.xingyi.reference3.person.server.controller.IPersonController;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

abstract class AbstractResourceDetailsClientTest {
    static Json json = new Json();
    static EndpointConfig<Object> config = EndpointConfig.defaultConfig((JsonParserAndWriter)json);
    static PersonController controller = new PersonController((JsonParser)AbstractResourceDetailsClientTest.config.parserAndWriter);
    static PersonServer<Object> server = new PersonServer(config, (IPersonController)controller);
    static EndPoint entityEndpoints = EndPoint.printlnLog((EndPoint)EndPoint.compose((List)server.allEndpoints(), (boolean)true));
    HttpServiceCompletableFuture rawService;

    AbstractResourceDetailsClientTest() {
    }

    protected abstract Function<ServiceRequest, CompletableFuture<ServiceResponse>> httpClient();

    protected abstract String expectedHost();

    HttpServiceCompletableFuture service() {
        if (this.rawService == null) {
            this.rawService = HttpServiceCompletableFuture.lensService((String)"http://localhost:9000", (JsonParserAndWriter)AbstractResourceDetailsClientTest.config.parserAndWriter, this.httpClient());
        }
        return this.rawService;
    }

    @Before
    public void resetData() {
        controller.reset();
    }

    @Test
    public void testGetPrimitive() throws ExecutionException, InterruptedException {
        TestCase.assertEquals((String)(this.expectedHost() + "/person/{id}"), (String)((String)this.service().primitive((IXingYiRemoteAccessDetails)UrlPatternCompanion.companion, "get", "/person", UrlPattern::urlPattern).get()));
        TestCase.assertEquals((String)(this.expectedHost() + "/person/{id}"), (String)((String)UrlPatternCompanion.companion.primitive(this.service(), "get", "/person", e -> e.urlPattern()).get()));
    }

    @Test
    public void testGetJavascript() throws ExecutionException, InterruptedException {
        DigestAndString digestAndString = AbstractResourceDetailsClientTest.server.context.javascriptStore.findDigestAndString(List.of());
        ServiceRequest sr = new ServiceRequest("get", this.expectedHost() + "/person/code/" + digestAndString.digest, List.of(), "");
        ServiceResponse serviceResponse = this.httpClient().apply(sr).get();
        TestCase.assertEquals((String)serviceResponse.toString(), (int)200, (int)serviceResponse.statusCode);
        TestCase.assertEquals((String)digestAndString.string, (String)serviceResponse.body);
    }

    @Test
    public void testGetUrlPattern() throws ExecutionException, InterruptedException {
        TestCase.assertEquals((String)(this.expectedHost() + "/person/{id}"), (String)((String)PersonNameViewCompanion.companion.getUrlPattern(this.service()).get()));
    }

    @Test
    public void testGetUrlPatternWhenEntityNotRegistered() throws ExecutionException, InterruptedException {
        try {
            UrlPatternCompanion.companion.primitive(this.service(), "get", "/notin", UrlPattern::urlPattern).get();
            Assert.fail();
        }
        catch (Exception e) {
            Throwable cause = e.getCause().getCause();
            Assert.assertTrue((String)cause.getClass().getName(), (boolean)(cause instanceof UnexpectedResponse));
            TestCase.assertEquals((int)404, (int)((UnexpectedResponse)cause).response.statusCode);
        }
    }

    @Test
    public void testGetPerson() throws ExecutionException, InterruptedException {
        TestCase.assertEquals((String)"someName", (String)((String)PersonNameView.get((HttpServiceCompletableFuture)this.service(), (String)"id1", PersonNameView::name).get()));
    }

    @Test
    public void testGetOptionalPerson() throws ExecutionException, InterruptedException {
        TestCase.assertEquals(Optional.of("someName"), PersonNameView.getOptional((HttpServiceCompletableFuture)this.service(), (String)"id1", PersonNameView::name).get());
        TestCase.assertEquals(Optional.empty(), PersonNameView.getOptional((HttpServiceCompletableFuture)this.service(), (String)"notin", PersonNameView::name).get());
    }

    @Test
    public void testCreate() throws ExecutionException, InterruptedException {
        PersonLine12View prototype = (PersonLine12View)PersonLine12View.create((HttpServiceCompletableFuture)this.service(), (String)"prototype").get();
        PersonLine12View newView = prototype.withline1("newLine1").withline2("newLine2");
        System.out.println(prototype.xingYi().render("json", (IXingYiView)newView));
        IdAndValue idAndView = (IdAndValue)PersonLine12View.create((HttpServiceCompletableFuture)this.service(), (PersonLine12View)newView).get();
        TestCase.assertEquals((String)"2", (String)idAndView.id);
        TestCase.assertEquals((String)"newLine1newLine2", (String)(((PersonLine12View)idAndView.t).line1() + ((PersonLine12View)idAndView.t).line2()));
    }

    @Test
    public void testEditPerson() throws ExecutionException, InterruptedException {
        PersonLine12View.edit((HttpServiceCompletableFuture)this.service(), (String)"id1", i -> i.withline1("newLine1").withline2("newLine2")).get();
        TestCase.assertEquals(Optional.of("someNamenewLine1newLine2"), IPersonNameLine12View.getOptional((HttpServiceCompletableFuture)this.service(), (String)"id1", i -> i.name() + i.line1() + i.line2()).get());
    }

    @Test
    public void testPrototypePerson() throws ExecutionException, InterruptedException {
        PersonLine12View.prototype((HttpServiceCompletableFuture)this.service(), (String)"id2", i -> i.withline1("newLine1").withline2("newLine2")).get();
        TestCase.assertEquals(Optional.of("prototypenewLine1newLine2"), IPersonNameLine12View.getOptional((HttpServiceCompletableFuture)this.service(), (String)"id2", i -> i.name() + i.line1() + i.line2()).get());
    }

    @Test
    public void testGetCompositePerson() throws ExecutionException, InterruptedException {
        TestCase.assertEquals((String)"someNamesomeLine1", (String)((String)IPersonNameLine12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", i -> i.name() + i.line1()).get()));
        TestCase.assertEquals(Optional.of("someNamesomeLine1"), IPersonNameLine12View.getOptional((HttpServiceCompletableFuture)this.service(), (String)"id1", i -> i.name() + i.line1()).get());
    }

    @Test
    public void testEditCompositePerson() throws ExecutionException, InterruptedException {
        IPersonNameLine12View.edit((HttpServiceCompletableFuture)this.service(), (String)"id1", i -> i.withname("newName").withline1("newLine1").withline2("newLine2")).get();
        TestCase.assertEquals(Optional.of("newNamenewLine1newLine2"), IPersonNameLine12View.getOptional((HttpServiceCompletableFuture)this.service(), (String)"id1", i -> i.name() + i.line1() + i.line2()).get());
    }

    @Test
    public void testDeleteCompositePerson() throws ExecutionException, InterruptedException {
        IPersonNameLine12View.delete((HttpServiceCompletableFuture)this.service(), (String)"id1").get();
        TestCase.assertEquals(Optional.empty(), IPersonNameLine12View.getOptional((HttpServiceCompletableFuture)this.service(), (String)"id1", i -> i.name() + i.line1()).get());
    }

    @Test
    public void testPrototypeCompositePerson() throws ExecutionException, InterruptedException {
        IPersonNameLine12View.prototype((HttpServiceCompletableFuture)this.service(), (String)"id2", i -> i.withname("newName").withline1("newLine1").withline2("newLine2")).get();
        TestCase.assertEquals(Optional.of("newNamenewLine1newLine2"), IPersonNameLine12View.getOptional((HttpServiceCompletableFuture)this.service(), (String)"id2", i -> i.name() + i.line1() + i.line2()).get());
    }

    @Test
    public void testCreateWithIdWithComposite() throws ExecutionException, InterruptedException {
        IPersonNameLine12View view = (IPersonNameLine12View)IPersonNameLine12View.create((HttpServiceCompletableFuture)this.service(), (String)"newId").get();
        TestCase.assertEquals((String)"newId", (String)view.name());
    }

    @Test
    public void testCreateWithComposite() throws ExecutionException, InterruptedException {
        IPersonNameLine12View prototype = (IPersonNameLine12View)IPersonNameLine12View.create((HttpServiceCompletableFuture)this.service(), (String)"prototype").get();
        IPersonNameLine12View newView = prototype.withname("newName").withline1("newLine1").withline2("newLine2");
        System.out.println(prototype.xingYi().render("json", (IXingYiView)newView));
        IdAndValue idAndView = (IdAndValue)IPersonNameLine12View.create((HttpServiceCompletableFuture)this.service(), (IPersonNameLine12View)newView).get();
        TestCase.assertEquals((String)"2", (String)idAndView.id);
        TestCase.assertEquals((String)"newNamenewLine1newLine2", (String)(((IPersonNameLine12View)idAndView.t).name() + ((IPersonNameLine12View)idAndView.t).line1() + ((IPersonNameLine12View)idAndView.t).line2()));
    }
}

