/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.test;

import java.util.List;
import one.xingyi.core.client.IResourceList;
import one.xingyi.core.client.IXingYi;
import one.xingyi.core.client.IXingYiFactory;
import one.xingyi.core.endpoints.EndpointConfig;
import one.xingyi.core.endpoints.EndpointContext;
import one.xingyi.core.marshelling.ContextForJson;
import one.xingyi.core.marshelling.JsonParserAndWriter;
import one.xingyi.core.marshelling.JsonWriter;
import one.xingyi.json.Json;
import one.xingyi.reference3.address.client.view.AddressLine12View;
import one.xingyi.reference3.address.server.companion.AddressCompanion;
import one.xingyi.reference3.person.client.view.PersonAddresses12ViewImpl;
import one.xingyi.reference3.person.server.companion.PersonCompanion;
import one.xingyi.test.IReferenceFixture3;
import org.junit.Assert;
import org.junit.Test;

public class MirroredSimpleListTest
implements IReferenceFixture3 {
    EndpointConfig<Object> config = EndpointConfig.defaultConfig((JsonParserAndWriter)new Json());
    EndpointContext<Object> context = this.config.from(List.of(PersonCompanion.companion, AddressCompanion.companion));
    IXingYiFactory factory = IXingYiFactory.simple;
    IXingYi xingyi;
    String personJson;
    PersonAddresses12ViewImpl view;

    public MirroredSimpleListTest() {
        this.xingyi = this.factory.apply((String)this.context.javascriptDetailsToString.apply((Object)this.context.javascriptStore.find(List.of())));
        this.personJson = this.config.parserAndWriter.fromJ(IReferenceFixture3.person.toJson((JsonWriter)this.config.parserAndWriter, ContextForJson.nullContext));
        this.view = new PersonAddresses12ViewImpl(this.xingyi, this.xingyi.parse(this.personJson));
    }

    @Test
    public void testWithOneAddress() {
        Assert.assertEquals((long)2L, (long)this.view.addresses().size());
        Assert.assertEquals((Object)"someLine1a", (Object)((AddressLine12View)this.view.addresses().get(0)).line1());
        Assert.assertEquals((Object)"someLine1b", (Object)((AddressLine12View)this.view.addresses().get(1)).line1());
    }

    @Test
    public void testAddAnAddress() {
        AddressLine12View prototype = (AddressLine12View)this.view.addresses().get(0);
        AddressLine12View line2 = prototype.withline1("someLineFor2");
        IResourceList with2 = this.view.addresses().append((Object)line2);
        Assert.assertEquals((long)2L, (long)this.view.addresses().size());
        Assert.assertEquals((Object)"someLine1a", (Object)((AddressLine12View)this.view.addresses().get(0)).line1());
        Assert.assertEquals((long)3L, (long)with2.size());
        Assert.assertEquals((Object)"someLine1a", (Object)((AddressLine12View)with2.get(0)).line1());
        Assert.assertEquals((Object)"someLine1b", (Object)((AddressLine12View)with2.get(1)).line1());
        Assert.assertEquals((Object)"someLineFor2", (Object)((AddressLine12View)with2.get(2)).line1());
    }
}

