/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.sqlAndParams;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import one.xingyi.sqlAndParams.SqlAndParams;

public interface ISqlAndParams {
    public String getPreSql();

    public String getPostSql();

    public List<Object> getParams();

    public static ISqlAndParams preSql(String sql, Object ... params) {
        return new SqlAndParams(sql, "", Arrays.asList(params));
    }

    public static ISqlAndParams of(String preSql, String postSql, Object ... params) {
        return new SqlAndParams(preSql, postSql, Arrays.asList(params));
    }

    public static ISqlAndParams postSql(String sql, Object ... params) {
        return new SqlAndParams("", sql, Arrays.asList(params));
    }

    public static ISqlAndParams merge(List<ISqlAndParams> sqlAndParams) {
        StringBuilder preSql = new StringBuilder();
        StringBuilder postSql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        for (ISqlAndParams sap : sqlAndParams) {
            if (preSql.length() > 0) {
                preSql.append(' ');
            }
            preSql.append(sap.getPreSql().trim());
            if (postSql.length() > 0) {
                postSql.append(' ');
            }
            postSql.append(sap.getPostSql().trim());
            params.addAll(sap.getParams());
        }
        return new SqlAndParams(preSql.toString(), postSql.toString(), params);
    }
}

