/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.sqlAndParams;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import one.xingyi.fp.IPartialFunction;
import one.xingyi.fp.Safe;
import one.xingyi.helpers.ListHelpers;
import one.xingyi.sqlAndParams.SqlAndParams;

public interface ISqlAndParams {
    public static <Req> Function<Req, ISqlAndParams> mergeLists(List<List<IPartialFunction<Req, ISqlAndParams>>> list) {
        List listOrResultFns = ListHelpers.map(list, l -> IPartialFunction.mapReduceFn((Collection)l, ISqlAndParams::merge));
        return req -> ISqlAndParams.mergePreAndPostsIntoPres(ListHelpers.map((List)listOrResultFns, fn -> (ISqlAndParams)fn.apply(req)));
    }

    public String getPreSql();

    public String getPostSql();

    public List<Object> getParams();

    default public String getFullSql() {
        return this.getPreSql() + " " + this.getPostSql();
    }

    public static ISqlAndParams preSql(String sql, Object ... params) {
        return new SqlAndParams(sql, "", Arrays.asList(params));
    }

    public static ISqlAndParams of(String preSql, String postSql, Object ... params) {
        return new SqlAndParams(preSql, postSql, Arrays.asList(params));
    }

    public static ISqlAndParams postSql(String sql, Object ... params) {
        return new SqlAndParams("", sql, Arrays.asList(params));
    }

    public static ISqlAndParams merge(List<ISqlAndParams> sqlAndParams) {
        StringBuilder preSql = new StringBuilder();
        StringBuilder postSql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        for (ISqlAndParams sap : sqlAndParams) {
            if (preSql.length() > 0) {
                preSql.append(' ');
            }
            preSql.append(sap.getPreSql().trim());
            if (postSql.length() > 0) {
                postSql.append(' ');
            }
            postSql.append(sap.getPostSql().trim());
            params.addAll(sap.getParams());
        }
        return new SqlAndParams(preSql.toString(), postSql.toString(), params);
    }

    public static ISqlAndParams mergePreAndPostsIntoPres(List<ISqlAndParams> sqlAndParams) {
        StringBuilder preSql = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        for (ISqlAndParams sap : sqlAndParams) {
            if (preSql.length() > 0) {
                preSql.append(' ');
            }
            preSql.append(sap.getPreSql().trim());
            if (preSql.length() > 0) {
                preSql.append(' ');
            }
            preSql.append(sap.getPostSql().trim());
            params.addAll(sap.getParams());
        }
        return new SqlAndParams(preSql.toString(), "", params);
    }

    public static <Query> IPartialFunction<Query, ISqlAndParams> always(Function<Query, ISqlAndParams> fn) {
        return IPartialFunction.always(fn);
    }

    public static <Query, T> IPartialFunction<Query, ISqlAndParams> fieldInWhere(Function<Query, T> fieldFn, Function<Query, String> sqlFn) {
        return IPartialFunction.of(query -> fieldFn.apply(query) != null, query -> ISqlAndParams.postSql((String)sqlFn.apply(query), fieldFn.apply(query)));
    }

    public static <Query> IPartialFunction<Query, ISqlAndParams> stringFieldInWhere(Function<Query, String> fieldFn, Function<Query, String> sqlFn) {
        return IPartialFunction.of(query -> Safe.safeString((String)((String)fieldFn.apply(query))).length() > 0, query -> ISqlAndParams.postSql((String)sqlFn.apply(query), fieldFn.apply(query)));
    }

    public static <Query> IPartialFunction<Query, ISqlAndParams> stringFieldInWhereUpperCaseAndTrim(Function<Query, String> fieldFn, Function<Query, String> sqlFn) {
        return IPartialFunction.of(query -> Safe.safeString((String)((String)fieldFn.apply(query))).length() > 0, query -> ISqlAndParams.postSql((String)sqlFn.apply(query), ((String)fieldFn.apply(query)).trim().toUpperCase()));
    }
}

