/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.sqlAndParamsTest;

import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import one.xingyi.fp.IPartialFunction;
import one.xingyi.sqlAndParams.ISqlAndParams;
import one.xingyi.sqlAndParamsTest.SqlAndParamsMismatchException;

public interface ISqlAndParamsTest {
    public static void checkSqlLegal(String sql) throws JSQLParserException {
        if (sql.trim().length() == 0) {
            throw new JSQLParserException("Empty sql");
        }
        CCJSqlParserUtil.parse((String)sql);
    }

    public static void checkParamsCountAgainstSql(ISqlAndParams sqlAndParams) {
        int paramsCount;
        String sql = sqlAndParams.getFullSql();
        long count = sql.chars().filter(c -> c == 63).count();
        if (count != (long)(paramsCount = sqlAndParams.getParams().size())) {
            throw new SqlAndParamsMismatchException("SqlAndParams mismatch. Count of ?s " + count + " and params " + paramsCount + "\nSql: " + sql + "\nparams: " + sqlAndParams.getParams());
        }
    }

    public static void checkSqlAndParamsLegal(ISqlAndParams sqlAndParams) throws JSQLParserException {
        String sql = sqlAndParams.getFullSql();
        ISqlAndParamsTest.checkSqlLegal(sql);
        ISqlAndParamsTest.checkParamsCountAgainstSql(sqlAndParams);
    }

    public static <Req> void checkSqlAndParamsPfnListLegal(Req req, List<IPartialFunction<Req, ISqlAndParams>> pfnList) throws JSQLParserException {
        ISqlAndParams merged = (ISqlAndParams)IPartialFunction.mapReduceFn(pfnList, ISqlAndParams::merge).apply(req);
        ISqlAndParamsTest.checkSqlAndParamsLegal(merged);
    }

    public static <Req> void testPermutations(Req req, List<IPartialFunction<Req, ISqlAndParams>> pfnList) {
        IPartialFunction.forEachPermutation(pfnList, req, (booleans, list) -> {
            ISqlAndParams merged = ISqlAndParams.merge((List)list);
            try {
                ISqlAndParamsTest.checkSqlAndParamsLegal(merged);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed for " + booleans + " " + merged, e);
            }
        });
    }
}

