/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.validation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import one.xingyi.helpers.ListHelpers;
import one.xingyi.interfaces.Delegate;
import one.xingyi.validation.ValidationException;

public interface IValidate<T>
extends BiFunction<List<String>, T, List<String>> {
    public static <T> IValidate<T> shouldBe(String messagePattern, Predicate<T> fn) {
        return (path, t) -> fn.test(t) ? Collections.emptyList() : Collections.singletonList(MessageFormat.format(messagePattern, path, t));
    }

    public static <T> IValidate<T> shouldBe(Supplier<String> messagePattern, Predicate<T> fn) {
        return (path, t) -> fn.test(t) ? Collections.emptyList() : Collections.singletonList(MessageFormat.format((String)messagePattern.get(), path, t));
    }

    public static <T> IValidate<T> shouldNotBe(String messagePattern, Predicate<T> fn) {
        return IValidate.shouldBe(messagePattern, fn.negate());
    }

    public static <T> IValidate<T> shouldNotBe(Supplier<String> messagePattern, Predicate<T> fn) {
        return IValidate.shouldBe(messagePattern, fn.negate());
    }

    public static <T, Field> IValidate<T> fieldShouldBe(String fieldName, Function<T, Field> fieldFn, String messagePattern, Predicate<Field> fn) {
        return IValidate.validateChild(fieldName, fieldFn, IValidate.shouldBe(messagePattern, fn));
    }

    public static <T, Field> IValidate<T> fieldShouldBe(String fieldName, Function<T, Field> fieldFn, Supplier<String> messagePattern, Predicate<Field> fn) {
        return IValidate.validateChild(fieldName, fieldFn, IValidate.shouldBe(messagePattern, fn));
    }

    public static <T> IValidate<T> notNull() {
        return IValidate.shouldBe("{0} is null", Objects::nonNull);
    }

    public static <T> IValidate<T> isOneOf(List<T> legalValues) {
        return IValidate.shouldBe(() -> "{0} is {1} which is not one of " + legalValues, legalValues::contains);
    }

    public static <T, Child> IValidate<T> validateChild(String childName, Function<T, Child> childFn, IValidate<Child> childValidator) {
        return (path, t) -> {
            Object child = childFn.apply(t);
            if (child == null) {
                return Collections.emptyList();
            }
            return (List)childValidator.apply(ListHelpers.append((List)path, (Object)childName), child);
        };
    }

    public static <T, Field> IValidate<T> fieldNotNull(String fieldName, Function<T, Field> fieldFn) {
        return (path, t) -> (List)IValidate.notNull().apply(ListHelpers.append((List)path, (Object)fieldName), fieldFn.apply(t));
    }

    public static IValidate<String> minLength(int minLength) {
        return IValidate.shouldBe("{0} Should have a min length of " + minLength, (T s) -> s.length() > minLength);
    }

    public static <T> IValidate<T> fieldMinLength(String fieldName, Function<T, String> fieldFn, int minLength) {
        return IValidate.validateChild(fieldName, fieldFn, IValidate.minLength(minLength));
    }

    public static IValidate<String> maxLength(int maxLength) {
        return IValidate.shouldBe("{0} Should have a max length of " + maxLength, (T s) -> s.length() > maxLength);
    }

    public static <T> IValidate<T> fieldMaxLength(String fieldName, Function<T, String> fieldFn, int maxLength) {
        return IValidate.validateChild(fieldName, fieldFn, IValidate.maxLength(maxLength));
    }

    public static IValidate<String> lengthBetween(int minLength, int maxLength) {
        return IValidate.compose(IValidate.minLength(minLength), IValidate.maxLength(maxLength));
    }

    public static <T> IValidate<T> fieldLengthBetween(String fieldName, Function<T, String> fieldFn, int minLength, int maxLength) {
        return IValidate.validateChild(fieldName, fieldFn, IValidate.lengthBetween(minLength, maxLength));
    }

    public static <T, Field> IValidate<T> fieldIsOneOf(String fieldName, Function<T, Field> fieldFn, List<Field> legalValues) {
        return IValidate.validateChild(fieldName, fieldFn, IValidate.isOneOf(legalValues));
    }

    @SafeVarargs
    public static <From> IValidate<From> compose(BiFunction<List<String>, From, List<String>> ... validators) {
        return (path, from) -> {
            ArrayList result = new ArrayList();
            for (BiFunction validator : validators) {
                result.addAll((Collection)validator.apply(path, from));
            }
            return result;
        };
    }

    public static <T> T validate(List<String> path, T t, BiFunction<List<String>, T, List<String>> validator) {
        List<String> errors = validator.apply(path, (List<String>)t);
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
        return t;
    }

    public static <From, To> Delegate<From, To> validateBefore(BiFunction<List<String>, From, List<String>> validator) {
        return bizLogic -> from -> bizLogic.apply(IValidate.validate(Collections.emptyList(), from, validator));
    }

    public static <From, To> Delegate<From, To> validateAfter(BiFunction<List<String>, To, List<String>> validator) {
        return bizLogic -> from -> IValidate.validate(Collections.emptyList(), bizLogic.apply(from), validator);
    }

    public static <From, To> Delegate<From, To> validateBeforeAndAfter(BiFunction<List<String>, From, List<String>> before, BiFunction<List<String>, To, List<String>> after) {
        return bizLogic -> from -> IValidate.validate(Collections.emptyList(), bizLogic.apply(IValidate.validate(Collections.emptyList(), from, before)), after);
    }
}

