package one.zoop.sdk.scanner

import androidx.activity.ComponentActivity
import one.zoop.sdk.scanner.interfaces.IZoopScannerSdk
import one.zoop.sdk.scanner.utils.LicenseManager

class ZoopScannerSdk private constructor() {

    companion object {
        @Volatile
        private var instance: IZoopScannerSdk? = null

        fun getInstance(activity: ComponentActivity): IZoopScannerSdk {
            return instance ?: synchronized(this) {
                instance ?: ZoopScannerSdkImpl(activity, LicenseManager).also { instance = it }
            }
        }
    }
}
