package one.zoop.sdk.scanner.data.network

import one.zoop.sdk.scanner.data.models.DocumentProcessorRequest
import one.zoop.sdk.scanner.data.models.DocumentProcessorResponse
import one.zoop.sdk.scanner.data.models.OcrRequest
import one.zoop.sdk.scanner.data.models.OcrResponse
import retrofit2.Response
import retrofit2.http.Body
import retrofit2.http.Header
import retrofit2.http.POST

// API Service
interface OcrApiService {

    @POST("v1/in/utility/ocr/lite")
    suspend fun uploadImageForOcr(
        @Header("Content-Type") contentType: String,   // Dynamic Header
        @Body request: OcrRequest
    ): Response<OcrResponse>

    @POST("v1/in/ml/document/processor")
    suspend fun processDocument(
        @Header("Content-Type") contentType: String,
        @Body request: DocumentProcessorRequest
    ): Response<DocumentProcessorResponse>
}