import one.zoop.sdk.scanner.data.models.DocumentData
import one.zoop.sdk.scanner.data.models.DocumentProcessorRequest
import one.zoop.sdk.scanner.data.models.DocumentProcessorResponse
import one.zoop.sdk.scanner.data.models.OcrData
import one.zoop.sdk.scanner.data.models.OcrRequest
import one.zoop.sdk.scanner.data.models.OcrResponse
import one.zoop.sdk.scanner.data.network.OcrApiService
import one.zoop.sdk.scanner.data.network.RetrofitClient

class OcrRepository(private val apiService: OcrApiService = RetrofitClient.ocrApiService) {
    // Function for OCR API
    suspend fun uploadImageForOcr(base64FrontImage: String, taskId: String, cardType:String,base64BackImage :String): retrofit2.Response<OcrResponse> {
        val data = apiService.uploadImageForOcr(
            contentType = "application/json",
            request = OcrRequest(
                data = OcrData(cardFrontImage = base64FrontImage, cardType = cardType, cardBackImage = base64BackImage),
                taskId = taskId
            )
        )

        return  data;
    }

    // Function for Document Processor API
    suspend fun processDocument(base64File: String): retrofit2.Response<DocumentProcessorResponse> {
        return apiService.processDocument(
            contentType = "application/json",
            request = DocumentProcessorRequest(
                data = DocumentData(documentFile = base64File)
            )
        )
    }
}
