package one.zoop.sdk.scanner.interfaces

import android.content.Context
import one.zoop.sdk.scanner.model.ScannerConfig
import one.zoop.sdk.scanner.model.ScannerResultData
interface IZoopScannerSdk {
    fun configureScanner(config: ScannerConfig)
    fun initializeLicenseKey(context: Context, licenseKey: String, orgPid: String? = null)
    fun start(callback: (Result<ScannerResultData<*>>) -> Unit)
}


// ===== MOCK Interface for Preview=======
class MockZoopScannerSdk : IZoopScannerSdk {
    override fun configureScanner(config: ScannerConfig) {
        println("Mock: Configuring scanner with config $config")
    }

    override fun initializeLicenseKey(context: Context, licenseKey: String, orgPid: String?) {
        println("Mock: Initializing license with key $licenseKey and orgPid $orgPid")
    }

    override fun start(callback: (Result<ScannerResultData<*>>) -> Unit) {
        callback(Result.success(ScannerResultData(data = "", createdAt = 123, status = "", message = "")))
    }
}