package one.zoop.sdk.scanner.model

import com.google.gson.Gson
import java.io.Serializable

interface ResultData<T> {
    val data: T?
    val createdAt: Long
    val status: String
    val message: String
}

class ScannerResultData<T>(
    override val data: T?,
    override val createdAt: Long,
    override val status: String,
    override val message: String
) : ResultData<T> , Serializable

fun <T> ScannerResultData<T>.toJson(): String {
    val gson = Gson()
    // Handle nullable strings with a default value
    return gson.toJson(
        mapOf(
            "data" to this.data,
            "createdAt" to this.createdAt,
            "status" to (this.status ?: ""),
            "message" to (this.message ?: "")
        )
    )
}