package one.zoop.sdk.scanner.model

data class ScannerConfig(
    val fileTypes: FileType,
    val mode: ScanMode,
    val isAutoEnabled: Boolean,
    val quality: Int,
    val primaryColor: Int,
    val ocrMode: OcrMode,
    val isIdCard:Boolean,
    val isBackImageRequired:Boolean,
    val documentName:String?,
    val primaryTextColor: Int
)
enum class FileType {
    JPEG, PNG, PDF
}

enum class ScanMode {
    BATCH, SINGLE, OCR,
}

enum class OcrMode(val title: String) {
    INVOICE_OCR("Invoice"),
    PAN_OCR("PAN Card"),
    AADHAAR_OCR("Aadhaar Card")
}