package one.zoop.sdk.scanner.model

import android.content.Context
import android.graphics.Color
import android.util.Log
import androidx.core.content.ContextCompat
import io.sentry.Sentry
import one.zoop.sdk.scanner.R

class ScannerConfigBuilder(private val context: Context) {
    private var documentName:String? = null
    private var fileTypes: FileType = FileType.JPEG
    private var mode: ScanMode = ScanMode.BATCH
    private var isAutoEnabled: Boolean = false
    private var quality: Int = 100
    private var primaryColor: Int = ContextCompat.getColor(context, R.color.colorPrimary)
    private var ocrMode: OcrMode = OcrMode.INVOICE_OCR
    private var isIdCard: Boolean = false
    private var isBackImageRequired:Boolean = false
    private var primaryTextColor:Int = ContextCompat.getColor(context, R.color.textColorPrimary)

    fun setMode(mode: ScanMode) = apply { this.mode = mode }
    fun setAutoEnabled(isAutoEnabled: Boolean) = apply { this.isAutoEnabled = isAutoEnabled }
    fun setQuality(quality: Int) = apply { this.quality = quality }
    fun setFileTypes(fileTypes: FileType) = apply { this.fileTypes = fileTypes }
    fun setOcrMode(ocrMode: OcrMode) = apply { this.ocrMode = ocrMode }
    fun setIdCardMode(isIdCard:Boolean) = apply { this.isIdCard = isIdCard }
    fun setDocumentName(documentName:String) = apply { this.documentName = documentName }
    fun setBackImageRequired(isBackImageRequired:Boolean) = apply {this.isBackImageRequired = isBackImageRequired}
    fun setPrimaryTextColor(colorString: String) = apply {
        try {
            this.primaryTextColor = Color.parseColor(colorString)
        } catch (e: IllegalArgumentException) {
            Sentry.captureException(e)
            Log.w("ScannerConfigBuilder", "Invalid color string: $colorString. Falling back to default color.")
            this.primaryColor = ContextCompat.getColor(context, R.color.colorPrimary)
        }
    }
    fun setPrimaryColor(colorString: String) = apply {
        try {
            this.primaryColor = Color.parseColor(colorString)
        } catch (e: IllegalArgumentException) {
            Sentry.captureException(e)
            Log.w("ScannerConfigBuilder", "Invalid color string: $colorString. Falling back to default color.")
            this.primaryColor = ContextCompat.getColor(context, R.color.colorPrimary)
        }
    }

    fun build() = ScannerConfig(fileTypes, mode, isAutoEnabled, quality, primaryColor, ocrMode,isIdCard,isBackImageRequired,documentName,primaryTextColor)
}
