package one.zoop.sdk.scanner.ui.core.components

import androidx.compose.foundation.background
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.Card
import androidx.compose.material3.CardDefaults
import androidx.compose.material3.Divider
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import androidx.compose.ui.window.Dialog

@Composable
fun ExitScanDialog(
    onDismissRequest: () -> Unit,
    onConfirmation: () -> Unit,
    title: String,
    body: String,
) {
    Dialog(onDismissRequest = onDismissRequest) {
        Card(
            modifier = Modifier, // Width matching the design
            colors = CardDefaults.cardColors(
                containerColor = Color.White
            ),
            shape = RoundedCornerShape(16.dp), // Rounded corners matching the design
        ) {
            Column {
                // Top section with title and body text
                Column(
                    modifier = Modifier
                        .fillMaxWidth()
                        .padding(horizontal = 24.dp, vertical = 20.dp),
                    horizontalAlignment = Alignment.CenterHorizontally
                ) {
                    // Title
                    Text(
                        text = title,
                        fontSize = 16.sp,
                        fontWeight = FontWeight.Bold,
                        color = Color.Black,
                        style = MaterialTheme.typography.headlineMedium,
                        textAlign = TextAlign.Center
                    )

                    Spacer(modifier = Modifier.height(12.dp))

                    // Body text
                    Text(
                        text = body,
                        fontSize = 14.sp,
                        style = MaterialTheme.typography.bodyLarge,
                        color = Color(0xFF666666), // Gray color matching the design
                        textAlign = TextAlign.Center,
                        lineHeight = 22.sp
                    )
                }

                // Horizontal divider
                Divider(
                    color = Color(0xFFEEEEEE),
                    thickness = 1.dp
                )

                // Bottom section with buttons
                Row(
                    verticalAlignment = Alignment.CenterVertically,
                    modifier = Modifier
                        .fillMaxWidth()
                        .height(50.dp) // Button height matching the design
                ) {
                    // No button
                    Box(
                        modifier = Modifier
                            .weight(1f)
                            .fillMaxWidth()
                            .clickable(onClick = onDismissRequest),
                        contentAlignment = Alignment.Center
                    ) {
                        Text(
                            text = "Cancel",
                            fontSize = 14.sp,
                            style = MaterialTheme.typography.titleMedium,
                            color = Color.Black
                        )
                    }

                    // Vertical divider
                    Divider(
                        modifier = Modifier
                            .height(50.dp)
                            .width(1.dp),
                        color = Color(0xFFEEEEEE)
                    )

                    // Exit button
                    Box(
                        modifier = Modifier
                            .weight(1f)
                            .fillMaxWidth()
                            .clickable(onClick = onConfirmation),
                        contentAlignment = Alignment.Center
                    ) {
                        Text(
                            text = "Exit",
                            fontSize = 14.sp,
                            style = MaterialTheme.typography.titleMedium,
                            color = Color(0xFFB22025) // Red color matching the design
                        )
                    }
                }
            }
        }
    }
}

@Preview(showBackground = true)
@Composable
fun PreviewExitScanDialog() {
    Surface {
        var showDialog by remember { mutableStateOf(true) }

        if (showDialog) {
            ExitScanDialog(
                onDismissRequest = { showDialog = false },
                onConfirmation = { showDialog = false },
                title = "Exit Scan?",
                body = "Your changes will not be saved. Are you sure you wish to exit?"
            )
        }
    }
}