package one.zoop.sdk.scanner.ui.navigation

import androidx.compose.animation.AnimatedContentTransitionScope
import androidx.compose.animation.core.tween
import androidx.compose.runtime.Composable
import androidx.navigation.compose.NavHost
import androidx.navigation.compose.composable
import androidx.navigation.compose.rememberNavController
import com.google.accompanist.pager.ExperimentalPagerApi
import one.zoop.sdk.scanner.ui.layout.Scanner.CameraScannerUI
import one.zoop.sdk.scanner.ui.layout.Preview.ImagePreviewScreen
import one.zoop.sdk.scanner.utils.ScannerConfigManager
import one.zoop.sdk.scanner.viewmodel.CameraViewModel


@OptIn(ExperimentalPagerApi::class)
@Composable
fun NavigationGraph(startDestination: String = "cameraScannerScreen", viewModel: CameraViewModel) {
    val navController = rememberNavController()
    viewModel.setScanName(ScannerConfigManager.getConfig()?.documentName)
    NavHost(navController = navController, startDestination = startDestination,
        enterTransition = {
            slideIntoContainer(
                AnimatedContentTransitionScope.SlideDirection.Left,
                tween(500)

            )
        },
        exitTransition = {
            slideOutOfContainer(
                AnimatedContentTransitionScope.SlideDirection.Left,
                tween(500)
            )
        },
        popEnterTransition = {
            slideIntoContainer(
                AnimatedContentTransitionScope.SlideDirection.Right,
                tween(500)
            )
        },
        popExitTransition = {
            slideOutOfContainer(
                AnimatedContentTransitionScope.SlideDirection.Right,
                tween(500)
            )
        }
    ) {
        composable(
            "cameraScannerScreen",

            ) {
            CameraScannerUI(viewModel, navController)
        }
        composable("previewScreen") {
            backStackEntry ->
            ImagePreviewScreen(viewModel, navController)
        }
    }
}