package one.zoop.sdk.scanner.utils

import androidx.compose.material3.Typography
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.font.Font
import androidx.compose.ui.text.font.FontFamily
import androidx.compose.ui.text.font.FontStyle
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.sp
import one.zoop.sdk.scanner.R

val GeistFontFamily: FontFamily = FontFamily(
    Font(R.font.geist_thin, FontWeight.Thin, FontStyle.Normal),
    Font(R.font.geist_extra_light, FontWeight.ExtraLight, FontStyle.Normal),
    Font(R.font.geist_light, FontWeight.Light, FontStyle.Normal),
    Font(R.font.geist_regular, FontWeight.Normal, FontStyle.Normal),
    Font(R.font.geist_medium, FontWeight.Medium, FontStyle.Normal),
    Font(R.font.geist_semi_bold, FontWeight.SemiBold, FontStyle.Normal),
    Font(R.font.geist_bold, FontWeight.Bold, FontStyle.Normal),
    Font(R.font.geist_extra_bold, FontWeight.ExtraBold, FontStyle.Normal),
    Font(R.font.geist_black, FontWeight.Black, FontStyle.Normal)
)

// Adding a bold text style that you can use directly
val BoldTextStyle: TextStyle = TextStyle(
    fontFamily = GeistFontFamily,
    fontWeight = FontWeight.Bold,
    fontSize = 16.sp
)

// Direct declaration with type annotation
val Typography: Typography = Typography(
    displayLarge = TextStyle(
        fontFamily = GeistFontFamily,
        fontWeight = FontWeight.Normal,
        fontSize = 57.sp
    ),
    displayMedium = TextStyle(
        fontFamily = GeistFontFamily,
        fontWeight = FontWeight.Normal,
        fontSize = 45.sp
    ),
    displaySmall = TextStyle(
        fontFamily = GeistFontFamily,
        fontWeight = FontWeight.Normal,
        fontSize = 36.sp
    ),
    headlineLarge = TextStyle(
        fontFamily = GeistFontFamily,
        fontWeight = FontWeight.Normal,
        fontSize = 32.sp
    ),
    headlineMedium = TextStyle(
        fontFamily = GeistFontFamily,
        fontWeight = FontWeight.Normal,
        fontSize = 28.sp
    ),
    headlineSmall = TextStyle(
        fontFamily = GeistFontFamily,
        fontWeight = FontWeight.Normal,
        fontSize = 24.sp
    ),
    titleLarge = TextStyle(
        fontFamily = GeistFontFamily,
        fontWeight = FontWeight.Medium,
        fontSize = 22.sp
    ),
    titleMedium = TextStyle(
        fontFamily = GeistFontFamily,
        fontWeight = FontWeight.Medium,
        fontSize = 16.sp
    ),
    titleSmall = TextStyle(
        fontFamily = GeistFontFamily,
        fontWeight = FontWeight.Medium,
        fontSize = 14.sp
    ),
    bodyLarge = TextStyle(
        fontFamily = GeistFontFamily,
        fontWeight = FontWeight.Normal,
        fontSize = 16.sp
    ),
    bodyMedium = TextStyle(
        fontFamily = GeistFontFamily,
        fontWeight = FontWeight.Normal,
        fontSize = 14.sp
    ),
    bodySmall = TextStyle(
        fontFamily = GeistFontFamily,
        fontWeight = FontWeight.Normal,
        fontSize = 12.sp
    ),
    labelLarge = TextStyle(
        fontFamily = GeistFontFamily,
        fontWeight = FontWeight.Medium,
        fontSize = 14.sp
    ),
    labelMedium = TextStyle(
        fontFamily = GeistFontFamily,
        fontWeight = FontWeight.Medium,
        fontSize = 12.sp
    ),
    labelSmall = TextStyle(
        fontFamily = GeistFontFamily,
        fontWeight = FontWeight.Medium,
        fontSize = 11.sp
    )
)