package one.zoop.sdk.scanner.data.models

import com.google.gson.annotations.SerializedName
import kotlin.reflect.KClass
import kotlin.reflect.full.memberProperties


// Document Processor Response

data class DocumentProcessorResponse(
    @SerializedName("request_id") val requestId: String?,
    @SerializedName("task_id") val taskId: String?,
    @SerializedName("group_id") val groupId: String?,
    @SerializedName("success") val success: Boolean,
    @SerializedName("response_code") val responseCode: String?,
    @SerializedName("response_message") val responseMessage: String?,
    @SerializedName("metadata") val metadata: Metadata?,
    @SerializedName("result") val result: DocumentResult?
)

data class DocumentResult(
    @SerializedName("chassis_number") val chassisNumber: String?,
    @SerializedName("engine_number") val engineNumber: String?,
    @SerializedName("invoice_number") val invoiceNumber: String?,
    @SerializedName("invoice_date") val invoiceDate: String?,
    @SerializedName("invoice_total_amount") val invoiceTotalAmount: String?,
    @SerializedName("customer_name") val customerName: String?,
    @SerializedName("dealer_name") val dealerName: String?,
    @SerializedName("financier") val financier: String?,
    @SerializedName("vehicle_model") val vehicleModel: String?
)

fun <T : Any> toMap(obj: T): Map<String, Any?> {
    return (obj::class as KClass<T>).memberProperties.associate { prop ->
        prop.name to prop.get(obj)?.let { value ->
            if (value::class.isData) {
                toMap(value)
            } else {
                value
            }
        }
    }
}
