package one.zoop.sdk.scanner.data.models

import com.google.gson.annotations.SerializedName

// Response Body
data class OcrResponse(
    @SerializedName("request_id") val requestId: String?,
    @SerializedName("task_id") val taskId: String?,
    @SerializedName("group_id") val groupId: String?,
    @SerializedName("success") val success: Boolean,
    @SerializedName("response_code") val responseCode: String?,
    @SerializedName("response_message") val responseMessage: String?,
    @SerializedName("metadata") val metadata: Metadata?,
    @SerializedName("result") val result: CardResult?
)

data class Metadata(
    @SerializedName("billable") val billable: String?,
    @SerializedName("reason_code") val reasonCode: String?,
    @SerializedName("reason_message") val reasonMessage: String?
)

data class CardResult(
    @SerializedName("card_info") val cardInfo: CardInfo?
)

data class CardInfo(
    @SerializedName("card_number") val cardNumber: String?,
    @SerializedName("date_of_birth") val dateOfBirth: String?,
    @SerializedName("type_of_date") val typeOfDate: String?,
    @SerializedName("father_name") val fatherName: String?,
    @SerializedName("name_on_card") val nameOnCard: String?,
    @SerializedName("card_type") val cardType: String?,
    @SerializedName("front_image_status") val frontImageStatus: Boolean?,
    @SerializedName("back_image_status") val backImageStatus: Boolean?
)