package one.zoop.sdk.scanner.model

import android.graphics.PointF
import android.net.Uri
import java.io.Serializable

data class ScannedPage(
    var rawImagePath: Uri,
    var processedImagePath: String? = null,
    var detectedCorners: List<PointF>? = null,
    var correctedCorners: List<PointF>? = null,
    var confidenceScore: Float? = null,
    var imageHeight: Double? = null,
    var imageWidth: Double? = null,
    var relativeImageHeight: Double? = null,
    var relativeImageWidth: Double? = null,
    var scaleFactorHeight: Double? = null,
    var scaleFactorWidth: Double? = null,
    var imageRotate: Float = 0f
)
: Serializable
