package one.zoop.sdk.scanner.ndk

///loads data from ndk/native  to kotlin
///All methods should use 'lock' as ndk are not thread safe
internal class NdkConnector {
    companion object {
        init {
            System.loadLibrary("native_lib")
        }

        @JvmStatic
        external fun passFromJNI(): String

        @Volatile
        private var modelPass: String? = null

        fun getModelPass(): String {
            return modelPass ?: synchronized(this) {
                modelPass ?: passFromJNI()
            }
        }

        external fun getApiKey(): String

        external fun getAppId(): String

        external fun getOcrApiKey(): String
    }
}