package one.zoop.sdk.scanner.ui.core.components

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.AlertDialog
import androidx.compose.material3.Button
import androidx.compose.material3.Card
import androidx.compose.material3.CardDefaults
import androidx.compose.material3.Divider
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import androidx.compose.ui.window.Dialog

//
//@Composable
//fun CropDialog(onDismiss: () -> Unit) {
//    Dialog(onDismissRequest = { onDismiss() }) {
//        AlertDialog(
//            onDismissRequest = { onDismiss() },
//            title = { Text(text = "Crop is too small") },
//            text = { Text(text = "Select a larger crop area to improve image quality.") },
//            confirmButton = {
//                Button(onClick = { onDismiss() }) {
//                    Text("Okay, got it")
//                }
//            }
//        )
//    }
//}

@Composable
fun CropDialog(
    onDismissRequest: () -> Unit,
) {
    Dialog(onDismissRequest = onDismissRequest) {
        Card(
            modifier = Modifier, // Width matching the design
            colors = CardDefaults.cardColors(
                containerColor = Color.White
            ),
            shape = RoundedCornerShape(16.dp), // Rounded corners matching the design
        ) {
            Column {
                // Top section with title and body text
                Column(
                    modifier = Modifier
                        .fillMaxWidth()
                        .padding(horizontal = 24.dp, vertical = 20.dp),
                    horizontalAlignment = Alignment.CenterHorizontally
                ) {
                    // Title
                    Text(
                        text = "Crop is too small",
                        fontSize = 16.sp,
                        color = Color.Black,
                        textAlign = TextAlign.Center,
                        style = MaterialTheme.typography.titleMedium,
                    )

                    Spacer(modifier = Modifier.height(12.dp))

                    // Body text
                    Text(
                        text = "Select a larger crop area to improve image quality.",
                        fontSize = 14.sp,
                        style = MaterialTheme.typography.bodyLarge,                        color = Color(0xFF666666), // Gray color matching the design
                        textAlign = TextAlign.Center,
                        lineHeight = 22.sp
                    )
                }

                // Horizontal divider
                Divider(
                    color = Color(0xFFEEEEEE),
                    thickness = 1.dp
                )

                Box(
                    modifier = Modifier
                        .fillMaxWidth().padding(vertical = 14.dp)
                        .clickable(onClick = onDismissRequest),
                    contentAlignment = Alignment.Center
                ) {
                    Text(
                        text = "Okay, got it",
                        fontSize = 14.sp,
                        style = MaterialTheme.typography.titleMedium,
                        color = Color(0xFF195BBF)
                    )
                }
            }
        }
    }
}


