package one.zoop.sdk.scanner.utils

import android.graphics.PointF

internal object ImageProcessor {

    fun convertAndScalePoints(
        points: List<android.graphics.PointF>,
        imageWidth: Double,
        imageHeight: Double
    ): List<List<Double>> {
        return points.map { point ->
            listOf(
                point.x * imageWidth,
                point.y * imageHeight
            )
        }
    }

    fun convertAndScalePointsToPointFArray(
        scaledPoints: List<List<Double>>,
    ): Array<PointF> {
        return scaledPoints.map { point ->
            PointF(
                (point[0]).toFloat(),
                (point[1]).toFloat()
            )
        }.toTypedArray()
    }

    fun getRelativePoints(
        points: List<android.graphics.PointF>,
        imageWidth: Double,
        imageHeight: Double
    ): List<PointF> {
        return points.map { point ->
            PointF(
                (point.x / imageWidth).toFloat(),
                (point.y / imageHeight).toFloat()
            )
        }
    }

    fun scaleImageAccordingToAspectRatio2(
        sourceImageHeight: Double,
        sourceImageWidth: Double,
        maxHeight: Double,
        maxWidth: Double,
    ): List<Double> {
        val scaleX = maxWidth / sourceImageWidth
        val scaleY = maxHeight / sourceImageHeight
        val scale = if (scaleX * sourceImageHeight > maxHeight) scaleY else scaleX

        val newWidth = sourceImageWidth * scale
        val newHeight = sourceImageHeight * scale
        val scaleFactorWidth = newWidth / sourceImageWidth
        val scaleFactorHeight = newHeight / sourceImageHeight

        return listOf(
            newHeight,
            newWidth,
            scaleFactorHeight,
            scaleFactorWidth
        )
    }




    fun pointProcessorAccordingToScale(
        points: List<List<Double>>,
        widthScaleFactor: Double,
        heightScaleFactor: Double
    ): List<List<Double>> {
        val scaledPoints = mutableListOf<List<Double>>()
        for (pointSet in points) {
            scaledPoints.add(
                listOf(
                    pointSet[0] * widthScaleFactor,
                    pointSet[1] * heightScaleFactor
                )
            )
        }
        return scaledPoints
    }

    fun pointProcessorNormalize(
        points: List<PointF>,
        viewWidth: Double,
        viewHeight: Double,
        imageWidth: Double,
        imageHeight: Double
    ): Array<PointF> {
        val normalizedPoints = mutableListOf<PointF>()

        for (point in points) {
            val normalizedX = (point.x ) * imageWidth
            val normalizedY = (point.y ) * imageHeight
            normalizedPoints.add(PointF(normalizedX.toFloat(), normalizedY.toFloat()))
        }

        return normalizedPoints.toTypedArray()
    }

    fun Double.roundToInt(): Int = Math.round(this).toInt()

}