package one.zoop.sdk.scanner.utils

import android.util.Log
import com.google.firebase.firestore.FirebaseFirestore
import io.sentry.Sentry
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

internal object TxnManager{
    private val firestoreService = FirestoreService(FirebaseFirestore.getInstance())
    private var currentTransactionId: String? = null

    fun startNewTransaction(clientId: String, orgPid: String, isSandbox: Boolean) {
        CoroutineScope(Dispatchers.IO).launch {
            try {
                // Log the new transaction and get the transaction ID
                val transactionId = firestoreService.logNewTransaction(clientId, orgPid, isSandbox)
                currentTransactionId = transactionId
            } catch (e: Exception) {
                Sentry.captureException(e);
                Log.e("TransactionManager", "Failed to start a new transaction: $e")
            }
        }
    }

    fun completeTransaction(success: Boolean, noOfTransactions : Int) {
        currentTransactionId?.let { txnId ->
            CoroutineScope(Dispatchers.IO).launch {
                try {
                    firestoreService.markTransactionCompleted(txnId, success, noOfTransactions)
                    currentTransactionId = null // Clear the transaction ID after completion
                } catch (e: Exception) {
                    Sentry.captureException(e);
                    Log.e("TransactionManager", "Failed to mark transaction completed: $e")
                }
            }
        }
    }
}