/*
 * Decompiled with CFR 0.152.
 */
package online.citizenshipverification.turkish.client;

import java.util.Objects;
import online.citizenshipverification.turkish.KisiVeCuzdanDogrula;
import online.citizenshipverification.turkish.KisiVeCuzdanDogrulaResponse;
import online.citizenshipverification.turkish.TCKimlikNoDogrula;
import online.citizenshipverification.turkish.TCKimlikNoDogrulaResponse;
import online.citizenshipverification.turkish.YabanciKimlikNoDogrula;
import online.citizenshipverification.turkish.YabanciKimlikNoDogrulaResponse;
import online.citizenshipverification.turkish.client.WebServiceException;
import online.citizenshipverification.turkish.utils.ProjectConstants;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.stereotype.Service;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.support.WebServiceGatewaySupport;

@Service
public class WebServiceClient
extends WebServiceGatewaySupport {
    WebServiceClient() {
        Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
        marshaller.setContextPath("online.citizenshipverification.turkish");
        this.setDefaultUri("http://tckimlik.nvi.gov.tr/WS");
        this.setMarshaller((Marshaller)marshaller);
        this.setUnmarshaller((Unmarshaller)marshaller);
    }

    public boolean isValid(TCKimlikNoDogrula request) {
        TCKimlikNoDogrulaResponse response = (TCKimlikNoDogrulaResponse)this.sendAndReceive("https://tckimlik.nvi.gov.tr/Service/KPSPublic.asmx", (Object)request, (WebServiceMessageCallback)ProjectConstants.TR_IDENTITY_NO_VALIDATE_SOAP_ACTION);
        return Objects.nonNull(response) && response.isTCKimlikNoDogrulaResult();
    }

    public boolean isValid(KisiVeCuzdanDogrula request) {
        KisiVeCuzdanDogrulaResponse response = (KisiVeCuzdanDogrulaResponse)this.sendAndReceive("https://tckimlik.nvi.gov.tr/Service/KPSPublicV2.asmx", (Object)request, (WebServiceMessageCallback)ProjectConstants.TR_IDENTITY_NO_DETAILED_VALIDATE_URI_SOAP_ACTION);
        return Objects.nonNull(response) && response.isKisiVeCuzdanDogrulaResult();
    }

    public boolean isValid(YabanciKimlikNoDogrula request) {
        YabanciKimlikNoDogrulaResponse response = (YabanciKimlikNoDogrulaResponse)this.sendAndReceive("https://tckimlik.nvi.gov.tr/Service/KPSPublicYabanciDogrula.asmx", (Object)request, (WebServiceMessageCallback)ProjectConstants.FOREIGN_IDENTITY_NO_VALIDATE_SOAP_ACTION);
        return Objects.nonNull(response) && response.isYabanciKimlikNoDogrulaResult();
    }

    private Object sendAndReceive(String URI2, Object requestPayload, WebServiceMessageCallback requestCallback) {
        try {
            return this.getWebServiceTemplate().marshalSendAndReceive(URI2, requestPayload, requestCallback);
        }
        catch (Exception e) {
            throw new WebServiceException(e);
        }
    }
}

