/*
 * Decompiled with CFR 0.152.
 */
package online.citizenshipverification.turkish.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@PropertySource(value={"classpath:swagger-info.properties"})
public class SwaggerConfiguration {
    @Value(value="${swagger.app-info.name}")
    private String appName;
    @Value(value="${swagger.app-info.description}")
    private String appDescription;
    @Value(value="${swagger.app-info.version}")
    private String appVersion;
    @Value(value="${swagger.app-info.license}")
    private String licence;
    @Value(value="${swagger.app-info.license-url}")
    private String licenceUrl;
    @Value(value="${swagger.contact.name}")
    private String contactName;
    @Value(value="${swagger.contact.url}")
    private String contactUrl;
    @Value(value="${swagger.contact.email}")
    private String contactEmail;

    @Bean
    public Docket api() {
        return new Docket(DocumentationType.SWAGGER_2).select().apis(RequestHandlerSelectors.basePackage((String)"online.citizenshipverification.turkish")).paths(PathSelectors.regex((String)"/.*")).build().apiInfo(this.getApiInformation());
    }

    private ApiInfo getApiInformation() {
        Contact contact = new Contact(this.contactName, this.contactUrl, this.contactEmail);
        return new ApiInfoBuilder().title(this.appName).version(this.appVersion).description(this.appDescription).license(this.licence).licenseUrl(this.licenceUrl).contact(contact).build();
    }
}

