/*
 * Decompiled with CFR 0.152.
 */
package online.citizenshipverification.turkish.controller;

import javax.validation.Valid;
import online.citizenshipverification.turkish.model.DetailedCitizenshipVerificationRequest;
import online.citizenshipverification.turkish.model.ForeignerCitizenshipVerificationRequest;
import online.citizenshipverification.turkish.model.SimpleCitizenshipVerificationRequest;
import online.citizenshipverification.turkish.service.VerificationService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TurkishCitizenshipVerificationController {
    private final VerificationService verificationService;

    @PostMapping(value={"/simple-verification"})
    public ResponseEntity<Boolean> simpleVerificationForTurkishIdentification(@Valid @RequestBody SimpleCitizenshipVerificationRequest request) {
        boolean isValid = this.verificationService.isValid(request);
        return ResponseEntity.ok((Object)isValid);
    }

    @PostMapping(value={"/detailed-verification"})
    public ResponseEntity<Boolean> detailedVerificationForTurkishIdentification(@Valid @RequestBody DetailedCitizenshipVerificationRequest request) {
        boolean isValid = this.verificationService.isValid(request);
        return ResponseEntity.ok((Object)isValid);
    }

    @PostMapping(value={"/foreigner-verification"})
    public ResponseEntity<Boolean> verificationForForeignerIdentification(@Valid @RequestBody ForeignerCitizenshipVerificationRequest request) {
        boolean isValid = this.verificationService.isValid(request);
        return ResponseEntity.ok((Object)isValid);
    }

    public TurkishCitizenshipVerificationController(VerificationService verificationService) {
        this.verificationService = verificationService;
    }
}

