/*
 * Decompiled with CFR 0.152.
 */
package online.inote.common.utils;

import java.util.Collection;
import java.util.Objects;
import online.inote.common.utils.StringUtils;
import online.inote.exception.AssertException;

public final class Assert {
    private Assert() {
    }

    public static void isNull(Object obj, String message) {
        if (!Objects.isNull(obj)) {
            throw new AssertException(message);
        }
    }

    public static void notNull(Object obj, String message) {
        if (Objects.isNull(obj)) {
            throw new AssertException(message);
        }
    }

    public static void isEmpty(Collection collection, String message) {
        if (collection != null && !collection.isEmpty()) {
            throw new AssertException(message);
        }
    }

    public static void notEmpty(Collection collection, String message) {
        if (collection == null || collection.isEmpty()) {
            throw new AssertException(message);
        }
    }

    public static void isEmpty(String str, String message) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            throw new AssertException(message);
        }
    }

    public static void notEmpty(String str, String message) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            throw new AssertException(message);
        }
    }

    public static void notBlank(String str, String message) {
        if (StringUtils.isBlank((CharSequence)str)) {
            throw new AssertException(message);
        }
    }

    public static void isTrue(boolean b, String message) {
        if (!b) {
            throw new AssertException(message);
        }
    }

    public static void isFalse(boolean b, String message) {
        if (b) {
            throw new AssertException(message);
        }
    }
}

