/*
 * Decompiled with CFR 0.152.
 */
package online.inote.common.utils.http;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import online.inote.common.utils.time.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogInterceptor
implements Interceptor {
    private static final String POST_METHOD = "POST";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        this.logger.info("request:[ {} ]" + request.toString());
        if (POST_METHOD.equals(request.method())) {
            this.logger.info("request-headers:[ {} ]", (Object)request.headers().toString());
            RequestBody requestBody = request.body();
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            this.logger.info("request-contentType:[ {} ]", (Object)requestBody.contentType().toString());
            this.logger.info("request-body:[ {} ]", (Object)buffer.readByteString().utf8());
        }
        Timer timer = Timer.builder().build();
        Response response = chain.proceed(request);
        this.logger.info(timer.costTipMessage());
        this.logger.info("response-code:[ {} ]", (Object)response.code());
        return response;
    }
}

