/*
 * Decompiled with CFR 0.152.
 */
package online.inote.common.utils.http;

import java.util.Map;
import okhttp3.MediaType;
import online.inote.common.utils.http.Result;

public abstract class Request {
    public static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    protected String baseUrl;
    protected String url;
    protected String targetUrl;
    protected Object requestBody;
    protected Map<String, String> headerParamMap;
    protected Map<String, String> urlParamMap;
    protected Map<String, Object> requestBodyMap;
    protected MediaType mediaType = APPLICATION_JSON;

    public abstract Result get();

    public abstract Result post();

    public abstract Result put();

    public abstract Result delete();

    public Request setRequestBody(Object params) {
        this.requestBody = params;
        return this;
    }

    public Request setRequestBody(String key, Object val) {
        this.requestBodyMap.put(key, val);
        return this;
    }

    public Request setHeaderParam(String key, String val) {
        this.headerParamMap.put(key, val);
        return this;
    }

    public Request setHeaderParam(Map<String, String> headerParamMap) {
        this.headerParamMap = headerParamMap;
        return this;
    }

    public Request setUrlParam(String key, String val) {
        this.urlParamMap.put(key, val);
        return this;
    }

    public Request setUrlParam(Map<String, String> headerParamMap) {
        this.urlParamMap = headerParamMap;
        return this;
    }

    public Request setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public Request setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        this.targetUrl = this.baseUrl + this.url;
        return this;
    }

    public Request setUrl(String url) {
        this.url = url;
        this.targetUrl = this.baseUrl + this.url;
        return this;
    }

    public Request setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
        return this;
    }
}

