/*
 * Decompiled with CFR 0.152.
 */
package online.inote.common.utils.time;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import online.inote.common.utils.Assert;
import online.inote.common.utils.time.Converter;
import online.inote.common.utils.time.DateTime;

public class Calculator {
    public static LocalDateTime getNow() {
        return LocalDateTime.now();
    }

    public static Date getNowDate() {
        return Converter.toDate(Calculator.getNow());
    }

    public static LocalDate getNowLocalDate() {
        return LocalDate.now();
    }

    public static LocalTime getNowLocalTime() {
        return LocalTime.now();
    }

    public static Date plus(Date date, long stepSize, TemporalUnit unit) {
        Assert.notNull(date, "date cannot be null");
        Assert.notNull(unit, "unit cannot be null");
        return Converter.toDate(Converter.toLocalDateTime(date).plus(stepSize, unit));
    }

    public static Date minus(Date date, long stepSize, TemporalUnit unit) {
        Assert.notNull(date, "date cannot be null");
        Assert.notNull(unit, "unit cannot be null");
        return Converter.toDate(Converter.toLocalDateTime(date).minus(stepSize, unit));
    }

    public static DateTime endTime(LocalDateTime dateTime) {
        return new DateTime(dateTime.toLocalDate().atTime(Calculator.endTimeOfDay()));
    }

    public static DateTime endTime(LocalDate date) {
        return new DateTime(date.atTime(Calculator.endTimeOfDay()));
    }

    public static DateTime endTime(Date date) {
        return new DateTime(Converter.toLocalDate(date).atTime(Calculator.endTimeOfDay()));
    }

    public static DateTime endTimeOfToday() {
        return new DateTime(Calculator.getNowLocalDate().atTime(Calculator.endTimeOfDay()));
    }

    public static DateTime endTimeOfThisWeek() {
        return new DateTime(Calculator.getNowLocalDate().atTime(Calculator.endTimeOfDay()));
    }

    public static LocalTime endTimeOfDay() {
        return LocalTime.MAX.withNano(0);
    }

    public static int getAge(LocalDate birthDay) {
        Assert.notNull(birthDay, "birthDay cannot be null");
        Period period = Calculator.periodBetween(birthDay, LocalDate.now());
        if (period.getYears() < 0) {
            throw new DateTimeException("birthDay is after now!");
        }
        return period.getYears();
    }

    public static int getAge(LocalDateTime birthDay) {
        return Calculator.getAge(Converter.toLocalDate(birthDay));
    }

    public static int getAge(Date birthDay) {
        return Calculator.getAge(Converter.toLocalDate(birthDay));
    }

    public static Period periodBetween(LocalDate startDateInclusive, LocalDate endDateExclusive) {
        return Period.between(startDateInclusive, endDateExclusive);
    }
}

