/*
 * Decompiled with CFR 0.152.
 */
package online.inote.common.utils.time;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import online.inote.common.utils.Assert;
import online.inote.common.utils.time.Zone;

public class Converter {
    public static Date toDate(LocalDateTime dateTime) {
        Assert.notNull(dateTime, "dateTime cannot be null");
        return Date.from(Converter.toInstant(dateTime));
    }

    public static Date toDate(LocalDate date) {
        Assert.notNull(date, "date cannot be null");
        return Date.from(date.atStartOfDay(Zone.DEFAULT).toInstant());
    }

    public static Date toDate(LocalTime time) {
        Assert.notNull(time, "date cannot be null");
        return Date.from(Converter.toInstant(LocalDate.now().atTime(time)));
    }

    public static Date toDate(Instant instant) {
        return Date.from(instant);
    }

    public static Date toDate(long epochMilli) {
        return new Date(epochMilli);
    }

    public static Date toDate(ZonedDateTime zonedDateTime) {
        Assert.notNull(zonedDateTime, "zonedDateTime cannot be null");
        return Date.from(zonedDateTime.toInstant());
    }

    public static Date toDate(TemporalAccessor temporal) {
        return Converter.toDate(Converter.toZonedDateTime(temporal));
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        Assert.notNull(date, "date cannot be null");
        return Instant.ofEpochMilli(date.getTime()).atZone(Zone.DEFAULT).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(Timestamp timestamp) {
        Assert.notNull(timestamp, "timestamp cannot be null");
        return timestamp.toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(LocalDate localDate) {
        Assert.notNull(localDate, "localDate cannot be null");
        return localDate.atStartOfDay();
    }

    public static LocalDateTime toLocalDateTime(LocalTime localTime) {
        Assert.notNull(localTime, "localTime cannot be null");
        return LocalDate.now().atTime(localTime);
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(long epochMilli) {
        Assert.notNull(epochMilli, "epochMilli cannot be null");
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), Zone.DEFAULT);
    }

    public static LocalDateTime toLocalDateTime(ZonedDateTime zonedDateTime) {
        Assert.notNull(zonedDateTime, "zonedDateTime cannot be null");
        return zonedDateTime.toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(TemporalAccessor temporal) {
        Assert.notNull(temporal, "temporal cannot be null");
        return Converter.toLocalDateTime(Converter.toZonedDateTime(temporal));
    }

    public static LocalDate toLocalDate(Date date) {
        Assert.notNull(date, "date cannot be null");
        return Converter.toLocalDateTime(date).toLocalDate();
    }

    public static LocalDate toLocalDate(LocalDateTime dateTime) {
        Assert.notNull(dateTime, "dateTime cannot be null");
        return dateTime.toLocalDate();
    }

    public static LocalDate toLocalDate(Instant instant) {
        return Converter.toLocalDateTime(instant).toLocalDate();
    }

    public static LocalDate toLocalDate(long epochMilli) {
        return Converter.toLocalDateTime(epochMilli).toLocalDate();
    }

    public static LocalDate toLocalDate(TemporalAccessor temporal) {
        return Converter.toLocalDateTime(temporal).toLocalDate();
    }

    public static LocalDate toLocalDate(ZonedDateTime zonedDateTime) {
        return Converter.toLocalDateTime(zonedDateTime).toLocalDate();
    }

    public static LocalDate toLocalDate(YearMonth yearMonth, int dayOfMonth) {
        Assert.notNull(yearMonth, "yearMonth cannot be null");
        return yearMonth.atDay(dayOfMonth);
    }

    public static ZonedDateTime toZonedDateTime(Date date) {
        return Converter.toZonedDateTime(date, Zone.DEFAULT);
    }

    public static ZonedDateTime toZonedDateTime(Date date, ZoneId zoneId) {
        Assert.notNull(date, "date cannot be null");
        Assert.notNull(zoneId, "zoneId cannot be null");
        return Instant.ofEpochMilli(date.getTime()).atZone(zoneId);
    }

    public static ZonedDateTime toZonedDateTime(LocalDateTime dateTime) {
        return Converter.toZonedDateTime(dateTime, Zone.DEFAULT);
    }

    public static ZonedDateTime toZonedDateTime(LocalDateTime dateTime, ZoneId zoneId) {
        Assert.notNull(dateTime, "dateTime cannot be null");
        Assert.notNull(zoneId, "zoneId cannot be null");
        return dateTime.atZone(zoneId);
    }

    public static ZonedDateTime toZonedDateTime(LocalDate date, ZoneId zoneId) {
        Assert.notNull(date, "date cannot be null");
        Assert.notNull(zoneId, "zoneId cannot be null");
        return date.atStartOfDay(zoneId);
    }

    public static ZonedDateTime toZonedDateTime(LocalDate date) {
        return Converter.toZonedDateTime(date, Zone.DEFAULT);
    }

    public static ZonedDateTime toZonedDateTime(TemporalAccessor temporal) {
        Assert.notNull(temporal, "temporal cannot be null");
        if (temporal instanceof Instant) {
            return Converter.toZonedDateTime((Instant)temporal);
        }
        if (temporal instanceof LocalDate) {
            return Converter.toZonedDateTime((LocalDate)temporal);
        }
        if (temporal instanceof LocalDateTime) {
            return Converter.toZonedDateTime((LocalDateTime)temporal);
        }
        if (temporal instanceof LocalTime) {
            return Converter.toZonedDateTime((LocalTime)temporal);
        }
        if (temporal instanceof ZonedDateTime) {
            return (ZonedDateTime)temporal;
        }
        if (temporal instanceof YearMonth) {
            return Converter.toZonedDateTime((YearMonth)temporal);
        }
        if (temporal instanceof OffsetDateTime) {
            return ((OffsetDateTime)temporal).toZonedDateTime();
        }
        if (temporal instanceof OffsetTime) {
            return ((OffsetTime)temporal).atDate(LocalDate.now()).toZonedDateTime();
        }
        return ZonedDateTime.from(temporal);
    }

    public static LocalTime toLocalTime(Date date) {
        Assert.notNull(date, "date cannot be null");
        return Converter.toZonedDateTime(date).toLocalTime();
    }

    public static LocalTime toLocalTime(LocalDateTime dateTime) {
        Assert.notNull(dateTime, "dateTime cannot be null");
        return dateTime.toLocalTime();
    }

    public static LocalTime toLocalTime(Instant instant) {
        Assert.notNull(instant, "instant cannot be null");
        return Converter.toZonedDateTime(instant).toLocalTime();
    }

    public static LocalTime toLocalTime(TemporalAccessor temporal) {
        Assert.notNull(temporal, "temporal cannot be null");
        return Converter.toZonedDateTime(temporal).toLocalTime();
    }

    public static LocalTime toLocalTime(ZonedDateTime zonedDateTime) {
        Assert.notNull(zonedDateTime, "zonedDateTime cannot be null");
        return zonedDateTime.toLocalTime();
    }

    public static Instant toInstant(Date date) {
        Assert.notNull(date, "date cannot be null");
        return date.toInstant();
    }

    public static Instant toInstant(LocalDateTime dateTime) {
        Assert.notNull(dateTime, "dateTime cannot be null");
        return dateTime.atZone(Zone.DEFAULT).toInstant();
    }

    public static Instant toInstant(LocalDate localDate) {
        return Converter.toZonedDateTime(localDate).toInstant();
    }

    public static Instant toInstant(LocalTime localTime) {
        return Converter.toZonedDateTime(localTime).toInstant();
    }

    public static Instant toInstant(long epochMilli) {
        return Instant.ofEpochMilli(epochMilli);
    }

    public static Instant toInstant(TemporalAccessor temporal) {
        return Converter.toInstant(Converter.toZonedDateTime(temporal));
    }

    public static Instant toInstant(ZonedDateTime zonedDateTime) {
        Assert.notNull(zonedDateTime, "zonedDateTime cannot be null");
        return zonedDateTime.toInstant();
    }

    public static Instant toInstant(Timestamp timestamp) {
        Assert.notNull(timestamp, "timestamp cannot be null");
        return timestamp.toInstant();
    }

    public static long toEpochMilli(Date date) {
        Assert.notNull(date, "date cannot be null");
        return date.getTime();
    }

    public static long toEpochMilli(LocalDateTime dateTime) {
        Assert.notNull(dateTime, "dateTime cannot be null");
        return Converter.toInstant(dateTime).toEpochMilli();
    }

    public static long toEpochMilli(LocalDate date) {
        Assert.notNull(date, "date cannot be null");
        return Converter.toInstant(date).toEpochMilli();
    }

    public static long toEpochMilli(Instant instant) {
        Assert.notNull(instant, "date cannot be null");
        return instant.toEpochMilli();
    }

    public static long toEpochMilli(ZonedDateTime zonedDateTime) {
        Assert.notNull(zonedDateTime, "zonedDateTime cannot be null");
        return zonedDateTime.toInstant().toEpochMilli();
    }

    public static long toEpochMilli(Timestamp timestamp) {
        Assert.notNull(timestamp, "date cannot be null");
        return timestamp.getTime();
    }

    public static long toEpochMilli(TemporalAccessor temporal) {
        Assert.notNull(temporal, "temporal cannot be null");
        return Converter.toEpochMilli(Converter.toZonedDateTime(temporal));
    }

    public static long convert(long sourceDuration, TimeUnit sourceUnit, TimeUnit targetUnit) {
        Assert.notNull((Object)sourceUnit, "sourceUnit cannot be null");
        Assert.notNull((Object)targetUnit, "targetUnit cannot be null");
        return targetUnit.convert(sourceDuration, sourceUnit);
    }

    public static BigDecimal convertPrecise(long sourceDuration, TimeUnit sourceUnit, TimeUnit targetUnit, int scope, RoundingMode roundingMode) {
        Assert.notNull((Object)sourceUnit, "sourceUnit cannot be null");
        Assert.notNull((Object)targetUnit, "targetUnit cannot be null");
        Assert.notNull((Object)roundingMode, "roundingMode cannot be null");
        return BigDecimal.valueOf(sourceDuration).multiply(BigDecimal.valueOf(sourceUnit.toNanos(1L))).divide(BigDecimal.valueOf(targetUnit.toNanos(1L)), scope, roundingMode);
    }
}

