/*
 * Decompiled with CFR 0.152.
 */
package online.inote.naruto.anti.replay.aspect;

import javax.servlet.http.HttpServletRequest;
import online.inote.naruto.anti.replay.annotation.NarutoAntiReplay;
import online.inote.naruto.anti.replay.props.ReplayProperties;
import online.inote.naruto.anti.replay.validator.AntiReplayValidator;
import online.inote.naruto.anti.replay.validator.SignatureValidator;
import online.inote.naruto.common.utils.SpringUtils;
import online.inote.naruto.utils.ConvertUtils;
import online.inote.naruto.utils.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Order(value=1)
@Aspect
@Component
public class AntiReplayAspect {
    private final ReplayProperties props;
    private final String servletContextPath;

    AntiReplayAspect(ReplayProperties props, Environment env) {
        this.props = props;
        this.servletContextPath = env.getProperty("server.servlet.context-path");
    }

    @Around(value="@annotation(narutoSecurity)")
    public Object around(ProceedingJoinPoint point, NarutoAntiReplay narutoSecurity) throws Throwable {
        HttpServletRequest request = this.getHttpServletRequest();
        if (narutoSecurity.checkSignature()) {
            SignatureValidator.builder().arguments(point.getArgs()).data(request).execute();
        }
        if (narutoSecurity.antiReplay()) {
            String targetUrl = StringUtils.replace((String)request.getRequestURI(), (String)this.servletContextPath, (String)"");
            try (AntiReplayValidator.AntiReplayWorker worker = AntiReplayValidator.builder().methodName(SpringUtils.getMethodName((ProceedingJoinPoint)point)).nonce(request.getHeader(this.props.getHeaderKey().getNonce())).url(request.getHeader(this.props.getHeaderKey().getUrl())).targetUrl(targetUrl).timestamp(ConvertUtils.StringToLong((String)request.getHeader(this.props.getHeaderKey().getTimestamp())));){
                worker.execute();
                Object object = point.proceed();
                return object;
            }
        }
        return point.proceed();
    }

    private HttpServletRequest getHttpServletRequest() {
        return this.getServletRequestAttributes().getRequest();
    }

    private ServletRequestAttributes getServletRequestAttributes() {
        return (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
    }
}

